//---------------------------------------------------------------------------------------------------------------
//  uarts.h
//
//  Copyright (c) 2025 Doug Broadwell, all rights reserved.
//---------------------------------------------------------------------------------------------------------------
//
//  Of the various ways to implement Uart register address variables (e.g., using the Tivaware defines for
//  base address + offsets) I just hard coded them here (from tm4C1231H6pm.h).
//
//---------------------------------------------------------------------------------------------------------------


#ifndef UARTS_H_
#define UARTS_H_


#include "common.h"
#include "sm_bluetooth.h"

//void TestUart(void);    // *FIXME* Testing

void Init_Uarts(void);


    /////////////////////////////////
    //  GENERAL USE SERIAL BUFFER  //
    /////////////////////////////////


const   int sBuffSize = 200;
extern char sBuff[sBuffSize];


    //////////////////////
    //  BLUETOOTH UART  //
    //////////////////////


//#define DEBUG_BT_TX                    // *FIXME*
//#define DEBUG_BT_RX


    //-- Circular Buffers --//

const int BtInCircBuffSize  = 1000;	// *FIXME* What are reasonable sizes for these?
const int BtOutCircBuffSize = 1000;     // Same as Debug buffer size.

struct BtInCircBuff_t {		        // Input Data Message buffer.
    int  HeadIdx;
    int  TailIdx;
    int  ChrCnt;			//
    int  MaxChrCnt;			// To see how big the buffers need to be. Not yet implemented.
    char Buff[BtInCircBuffSize];
};

struct BtOutCircBuff_t {		// Output Message buffer.
    int  HeadIdx;
    int  TailIdx;
    int  ChrCnt;			//
    int  MaxChrCnt;			// To see how big the buffers need to be. Not yet implemented.
    char Buff[BtOutCircBuffSize];
};

    //-- Linear Buffer --//

const  uint BtInExtraChrs   = 3;                    // Space for Msg # & Payload Size + 1 for ducks.
const  uint BtInLinBuffSize = 100 + BtInExtraChrs;  // *FIXME* What is a reasonable value.
extern char BtInLinBuff[];


#ifdef DEBUG_BT_TX                      // --- Debug Output Messages ---
                                        //
extern void DispCpuOutTraceBuff(void);  //
                                        //
    const int CpuOutTraceBuffSize=100;  //
                                        //
    struct CpuOutTraceBuff_t {          // Output Tracing buffer.
        int HeadIdx;                    //
        int TailIdx;                    // TailIdx not used.
        int ChrCnt;                     //
        u8  Buff[CpuOutTraceBuffSize];  //
    };                                  //
                                        //
#endif                                  // ------ End ------


#ifdef DEBUG_BT_RX                     // --- Debug Input Messages ---
                                        //
extern void DispCpuInTraceBuff(void);   //
                                        //
    const int CpuInTraceBuffSize = 100; //
                                        //
    struct CpuInTraceBuff_t {           // Output Tracing buffer.
        int HeadIdx;                    //
        int TailIdx;                    //
        int ChrCnt;                     //
        u8  Buff[CpuInTraceBuffSize];   //
    };                                  //
                                        //
#endif                                  // ------ End ------


void TxBtStr(uchar*);
inline void TxBtStr(const uchar* pChar) { TxBtStr(const_cast<uchar*>(pChar)); }

//inline void TxBtStr(const char*  pChar) { TxBtStr((uchar*)pChar); }
void TxBtStr(const char*  pChar);

void TxBtChar(uchar);
void BtChangeMsgMode(eBtCommMode Mode);
//void BtMsgReceived(void);

//extern void DisableBtComm(void);
//extern void ReEnableBtComm(void);


    //////////////////
    //  DEBUG UART  //
    //////////////////


const char CTL_C = 3;			// Control-C character.

enum   eInputMode { LINE_INPUT, ESCAPE_INPUT };
extern eInputMode InputMode;

const int  DbInBuffSize  =   50;	// Linear Buffer.
const int  DbOutBuffSize = 2000;	// Circular Buffer.
const int  DbMsgBuffSize =   80;	// For forming output strings
const int  MaxHistory    =    4;	// Number of command line history buffered.

struct DbOutCircBuff_t {		// Output Message buffer.
    int HeadIdx;                        //
    int TailIdx;                        //
    int ChrCnt;				//
    int MaxChrCnt;			// To see how big the buffers need to be.
    u8  Buff[DbOutBuffSize];            //
};

extern char  DbInBuff[DbInBuffSize];		    // Linear UART input line buffer.
extern int   DbInBuffIdx;			    // Input index into DbInBuff[].
extern char  CopyBuff[DbInBuffSize];		    // Copy of DbInBuff for parameter parsing & conversion.
extern char  LastBuff[MaxHistory][DbInBuffSize];    // Copy of last command string.
extern int   HistIdx;				    // Index into command history.
extern char  DbMsgBuff[DbMsgBuffSize];

void  DebugUartTxChrs(void);
void  StringAndPrompt(const char*);
void  ChangeDebugInputMode(eInputMode Mode);
 int  GetOutChrCnt(void);

void        TxDebugStr(char*);
inline void TxDebugStr(const char* pChar) { TxDebugStr(const_cast<char*>(pChar)); }

void        TxDbStrHex(char*);
inline void TxDbStrHex(const char* pChar) { TxDbStrHex(const_cast<char*>(pChar)); }


#endif /* UARTS_H_ */
