/*
 * Copyright (c) 2020, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "ti_msp_dl_config.h"


/* ((4MHz / 1 / (255 + 1)) * 0.5s) = 7813 - 1 = 7812 due to N+1 ticks */
#define TIMER_500_MILLISECONDS_TICKS (7812U)

/* ((4MHz / 1 / (255 + 1)) * 0.05s) = 781 - 1 = 780 due to N+1 ticks */
#define TIMER_50_MILLISECONDS_TICKS (780U)

uint8_t data = 0;
void(*rest)(void)=0x00005131;
uint8_t flag = 0;
int main(void)
{
    SYSCFG_DL_init();

    NVIC_ClearPendingIRQ(UART_0_INST_INT_IRQN);
    NVIC_EnableIRQ(UART_0_INST_INT_IRQN);
    NVIC_EnableIRQ(TIMER_0_INST_INT_IRQN);
   // DL_SYSCTL_enableSleepOnExit();
    DL_UART_Main_transmitData(UART_0_INST, 0x88);
    DL_TimerG_startCounter(TIMER_0_INST);
    //DL_UART_Main_transmitData(UART_0_INST, 0x);
    while (1) {
        delay_cycles(16000000);
        if(flag==1)
        {
            NVIC_ClearPendingIRQ(TIMER_0_INST_INT_IRQN);
            DL_Timer_reset(TIMER_0_INST);
            __disable_irq();
            flag= 0;
            rest();
        }
//        DL_GPIO_togglePins(GPIO_GRP_0_PORT, GPIO_GRP_0_PIN_0_PIN);
    }
}

void UART_0_INST_IRQHandler(void)
{
    switch (DL_UART_Main_getPendingInterrupt(UART_0_INST)) {
        case DL_UART_MAIN_IIDX_RX:
            data = DL_UART_Main_receiveData(UART_0_INST);
            if(data == 0x33)
            {
                DL_UART_Main_transmitData(UART_0_INST, 0x99);
                /* Waits until FIFO has space to fill the data */
                delay_cycles(16000000);
                flag= 1;
            }else
                DL_UART_Main_transmitData(UART_0_INST, data);
            break;
        default:
            break;
    }
}




void TIMER_0_INST_IRQHandler(void)
{
    static uint32_t count = TIMER_500_MILLISECONDS_TICKS;
    switch (DL_TimerG_getPendingInterrupt(TIMER_0_INST)) {
        case DL_TIMER_IIDX_ZERO:
            /*
             * Counter stopped to avoid a conflict with the timer reading
             * the LOAD value while it's being set
             */
            DL_TimerG_stopCounter(TIMER_0_INST);

            /*
             * Count progressively gets smaller in 0.05 s increments until reset
             * with 0.5s
             */
//            if (count > (TIMER_500_MILLISECONDS_TICKS / 5)) {
//                count = count - TIMER_50_MILLISECONDS_TICKS;
//            } else {
//                count = TIMER_500_MILLISECONDS_TICKS;
//            }
            count = TIMER_500_MILLISECONDS_TICKS;

            DL_Timer_setLoadValue(TIMER_0_INST, count);
            /*
             * By default, this should load the new count value and count down
             * from there (CVAE = 0)
             */
            DL_TimerG_startCounter(TIMER_0_INST);

    //        DL_UART_Main_transmitData(UART_0_INST, 0x14);

            DL_GPIO_togglePins(GPIO_LEDS_PORT, GPIO_LEDS_USER_LED_1_PIN);
            break;
        default:
            break;
    }
}


