/** @file HL_sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
#include "HL_can.h"
#include "HL_esm.h"
#include "HL_sys_core.h"

#define D_COUNT  512

uint8 RTI_TIMEOUT = 0;

uint32 cnt=0, error =0, tx_done =0;
uint8 tx_data[D_COUNT][8] = {0};
uint8 rx_data[D_COUNT][8] = {0};

uint8 *tx_ptr = &tx_data[0][0];
uint8 *rx_ptr = &rx_data[0][0];



uint8 *dptr=0;

uint32 round_cnt = 0;


void dumpSomeData(uint32 tmp);
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */

    /* enable irq interrupt in Cortex R4 */
    _enable_interrupt_();

    dumpSomeData(round_cnt);

    canInit();

    canEnableErrorNotification(canREG1);
    canEnableErrorNotification(canREG2);

    while(1){
        for(cnt=0;cnt<D_COUNT;cnt++)
                {
                    canTransmit(canREG1, canMESSAGE_BOX1, tx_ptr); /* transmitting 8 different chunks 1 by 1 */
                    while(tx_done == 0){};                 /* ... wait until transmit request is through        */
                    tx_done=0;
                    tx_ptr +=8;    /* next chunk ...*/
                }

                /** - check the received data with the one that was transmitted */
                tx_ptr = &tx_data[0][0];
                rx_ptr = &rx_data[0][0];

                for(cnt=0;cnt<(D_COUNT*8-1);cnt++)
                {
                    if(*tx_ptr++ != *rx_ptr++)
                    {
                           error++; /* data error */
                    }
                }
                tx_ptr = &tx_data[0][0];
                rx_ptr = &rx_data[0][0];
                // sci_printf("1->2 OK!\r\n");


                for(cnt=0;cnt<D_COUNT;cnt++)
                {
                    canTransmit(canREG2, canMESSAGE_BOX1, tx_ptr); /* transmitting 8 different chunks 1 by 1 */
                    while(tx_done == 0){};                 /* ... wait until transmit request is through        */
                    tx_done=0;
                    tx_ptr +=8;    /* next chunk ...*/
                }

                /** - check the received data with the one that was transmitted */
                tx_ptr = &tx_data[0][0];
                rx_ptr = &rx_data[0][0];

                for(cnt=0;cnt<(D_COUNT*8-1);cnt++)
                {
                    if(*tx_ptr++ != *rx_ptr++)
                    {
                           error++; /* data error */
                    }
                }
                tx_ptr = &tx_data[0][0];
                rx_ptr = &rx_data[0][0];
                // sci_printf("2->1 OK!\r\n");
                //sci_printf("CAN Test - Round %d OK! Total error %d. \r\n", round_cnt, error);
                round_cnt++;
                dumpSomeData(round_cnt);
    }; /* wait forever after tx-rx complete. */

/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
/* writing some data to ram  */
void dumpSomeData(uint32 tmp)
{
     //uint32 tmp = 0x11;

    tmp = tmp % 63;

     cnt = (D_COUNT*8)-1;
     dptr = &tx_data[0][0];
     *dptr = tmp;

     while(cnt--)
     {
        tmp = *dptr++;
        *dptr = tmp + 0x11;
     }
}


/* can interrupt notification */
/* Note-You need to remove canMessageNotification from notification.c to avoid redefinition */
void canMessageNotification(canBASE_t *node, uint32 messageBox)
{
    /* node 1 - transfer request */
    if((node==canREG1) && (messageBox == canMESSAGE_BOX1))
    {
      tx_done=1; /* confirm transfer request */
    }

    /* node 2 - receive complete */
    if((node==canREG2)  && (messageBox == canMESSAGE_BOX2))
    {
     while(!canIsRxMessageArrived(canREG2, canMESSAGE_BOX2));
     canGetData(canREG2, canMESSAGE_BOX2, rx_ptr); /* copy to RAM */
     rx_ptr +=8;
    }


   /* node 2 - transfer request */
    if((node==canREG2) && (messageBox == canMESSAGE_BOX1))
    {
      tx_done=1; /* confirm transfer request */
    }

    /* node 1 - receive complete */
    if((node==canREG1)  && (messageBox == canMESSAGE_BOX2))
    {
     while(!canIsRxMessageArrived(canREG1, canMESSAGE_BOX2));
     canGetData(canREG1, canMESSAGE_BOX2, rx_ptr); /* copy to RAM */
     rx_ptr +=8;
    }
    /* Note: since only message box 1 is used on both nodes we dont check it here.*/
}
/* USER CODE END */
