/*
 * can_test.cc
 *
 *  Created on: Dec 22, 2025
 *      Author: doug
 */

#include "common.h"

#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>

#include "tm4c123ae6pm.h"

#include "sysctl.h"
#include "pin_map.h"
#include "hw_memmap.h"
#include "hw_gpio.h"
#include "gpio.h"
#include "uart.h"

#include "can.h"
#include "hw_memmap.h"
#include "interrupt.h"
#include "hw_can.h"
#include "hw_types.h"




//-----------------------------
//  TRANSMIT STATUS MESSAGES  |
//---------------------------------------------------------------------------------------------------------------
void TxStr(char* pStr) {

    while(*pStr) {
        UART4_DR_R = *pStr;                     // Tx character.
        while(UART4_FR_R & UART_FR_BUSY) {}     // Wait till it's done.
        pStr++;                                 // Next character.
    }
}
//---------------------------------------------------------------------------------------------------------------




//------------------
//  CONFIGURE MPU  |
//---------------------------------------------------------------------------------------------------------------
void ConfigMPU(void) {

    SysCtlClockSet(SYSCTL_SYSDIV_2_5 | SYSCTL_XTAL_20MHZ | SYSCTL_USE_PLL | SYSCTL_OSC_MAIN);  // Should be 80MHz
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);                // Enable Port B, CAN Bus.
    while( ! SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOB)) {}
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC);                // Enable Port C, UART.
    while( ! SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOC)) {}
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOG);                // Enable Port G, Heartbeat LEDs.
    while( ! SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOG)) {}
    SysCtlPeripheralEnable(SYSCTL_PERIPH_CAN0);                 // Enable CAN 2.
    while( ! SysCtlPeripheralReady(SYSCTL_PERIPH_CAN0)) {}
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART4);                // Enable UART4 Debug Port.
    while( ! SysCtlPeripheralReady(SYSCTL_PERIPH_UART4)) {}

    GPIOPinTypeCAN  (GPIO_PORTB_BASE, PB_Can2Rx_BIT | PB_Can2Tx_BIT );  // CAN I/O
    GPIOPinConfigure(GPIO_PB4_CAN0RX);
    GPIOPinConfigure(GPIO_PB5_CAN0TX);

    GPIOPinTypeUART(GPIO_PORTC_BASE, PC_DebugRx_BIT | PC_DebugTx_BIT);      // UART I/O
    GPIOPinConfigure(GPIO_PC4_U4RX);
    GPIOPinConfigure(GPIO_PC5_U4TX);
    GPIO_PORTC_PDR_R = 0b11000000;                                          // Weak pull-down.

    GPIOPinTypeGPIOOutput(GPIO_PORTG_BASE, PG_HB_LED_BIT | PG_ER_LED_BIT);  // LEDs.

}
//---------------------------------------------------------------------------------------------------------------




//-------------
//  CAN TEST  |
//---------------------------------------------------------------------------------------------------------------
void CanTest(void) {

    char sBuff[200];
    volatile u32 i;

    static u8  Can0Data1[8];                // Message #17, Tx
    Can0Data1[0] = 0x12;
    Can0Data1[1] = 0x34;
    Can0Data1[2] = 0x56;
    Can0Data1[3] = 0x78;
    Can0Data1[4] = 0x12;
    Can0Data1[5] = 0x12;
    Can0Data1[6] = 0x12;
    Can0Data1[7] = 0x12;

    tCANMsgObject Can0MsgObj1;

    UARTConfigSetExpClk(UART4_BASE, 80000000, 19200,                // Init UART
         ( UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE ));

    CANInit(CAN0_BASE);                                             // Init CAN 0.
    if(CANBitRateSet(CAN0_BASE, 80000000, 500000) == 0) {
        TxStr("\r\n CANBitRateSet Failed\r\n");
        while(true) {}
    }
    CANEnable(CAN0_BASE);

    TxStr("\r\n");
    sprintf(sBuff, " Message not yet set, CAN0TXRQ1 = 0x%X\r\n", CAN0_TXRQ1_R);
    TxStr(sBuff);

    Can0MsgObj1.ui32MsgID     = 0x100;
    Can0MsgObj1.ui32MsgIDMask = 0;
    Can0MsgObj1.ui32Flags     = 0;
    Can0MsgObj1.ui32MsgLen    = 8;
    Can0MsgObj1.pui8MsgData   = Can0Data1;
    CANMessageSet(CAN0_BASE, 1, &Can0MsgObj1, MSG_OBJ_TYPE_TX);   // Send Message.

    uint Status = CAN0_TXRQ1_R;
    sprintf(sBuff, " Msg Started, CAN0TXRQ1 = 0x%X\r\n", Status);
    TxStr(sBuff);

    for(i=2000000; i != 0; i--) {}              // Delay a bit.

    sprintf(sBuff, " After Delay, CAN0TXRQ1 = 0x%X\r\n", CAN0_TXRQ1_R);
    TxStr(sBuff);

    while(true) {                               // Heartbeat LED.
        for(i=4000000; i != 0; i--) {}
        HB_LED_Toggle();
    }
}
//---------------------------------------------------------------------------------------------------------------
