int main(void){
	bool bTest;
	uint16_t uiTestArray[20];
    uint32_t ui32User0, ui32User1, ui32AnimPos, ui32Color;
    uint16_t uwTest;
    uint8_t pui8MACArray[8];
    tRectangle sRect;
    //
    // Run from the PLL at 120 MHz.
    //
    g_ui32SysClock = MAP_SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ |
                                             SYSCTL_OSC_MAIN | SYSCTL_USE_PLL |
                                             SYSCTL_CFG_VCO_480), 120000000);


    //
    // Determine the number of system clock cycles in 1mS
    //
	g_ui32ClockMS = CYCLES_FROM_TIME_US(g_ui32SysClock, 1000);
    //
    // Divide by 3 to get the number of SysCtlDelay loops in 1mS.
    //
    g_ui32ClockMS /= 3;

    //
    // Configure the device pins.
    //
    PinoutSet(g_ui32SysClock);

    //
    // Initialize the display driver.
    //
    Kentec320x240x16_SSD2119Init(g_ui32SysClock);

    //
    // Initialize the graphics context.
    //
    GrContextInit(&g_sContext, &g_sKentec320x240x16_SSD2119);

    //
    // Draw the application frame.
    //
    FrameDraw(&g_sContext, "enet-io");

    //
    // Configure SysTick for a periodic interrupt.
    //
    ROM_SysTickPeriodSet(g_ui32SysClock / SYSTICKHZ);
    ROM_SysTickEnable();
    ROM_SysTickIntEnable();


    //
    // Configure the hardware MAC address for Ethernet Controller filtering of
    // incoming packets.  The MAC address will be stored in the non-volatile
    // USER0 and USER1 registers.
    //
    ROM_FlashUserGet(&ui32User0, &ui32User1);
    if((ui32User0 == 0xffffffff) || (ui32User1 == 0xffffffff))
    {
        //
        // We should never get here.  This is an error if the MAC address has
        // not been programmed into the device.  Exit the program.
        //
        GrContextForegroundSet(&g_sContext, ClrRed);
        GrStringDrawCentered(&g_sContext, "MAC Address", -1,
                             GrContextDpyWidthGet(&g_sContext) / 2,
                             (GrContextDpyHeightGet(&g_sContext) / 2) - 4,
                             false);
        GrStringDrawCentered(&g_sContext, "Not Programmed!", -1,
                             GrContextDpyWidthGet(&g_sContext) / 2,
                             (GrContextDpyHeightGet(&g_sContext) / 2) + 16,
                             false);
        while(1)
        {
        }
    }

    //
    // Tell the user what we are doing just now.
    //
    GrStringDrawCentered(&g_sContext, "Waiting for IP", -1,
                         GrContextDpyWidthGet(&g_sContext) / 2,
                         STATUS_Y, false);

    //
    // Draw the box inside which a text string sent from browser will be
    // displayed.
    //
    sRect.i16XMin = 10;
    sRect.i16XMax = GrContextDpyWidthGet(&g_sContext) - sRect.i16XMin - 1;
    sRect.i16YMin = TEXT_BOX_TOP;
    sRect.i16YMax = TEXT_BOX_BOTTOM - 1;
    GrContextForegroundSet(&g_sContext, ClrWhite);
    GrRectDraw(&g_sContext, &sRect);
    GrContextFontSet(&g_sContext, g_psFontCmss18);
    GrStringDraw(&g_sContext, " Browser Text: ", -1, sRect.i16XMin + 6,
                 TEXT_BOX_TOP - 10, true);

    //
    // Draw the box inside which we will draw the animation.
    //
    sRect.i16XMin = ANIM_LEFT;
    sRect.i16XMax = (ANIM_LEFT + ANIM_WIDTH) - 1;
    sRect.i16YMin = ANIM_TOP;
    sRect.i16YMax = (ANIM_TOP + ANIM_HEIGHT) - 1;
    GrContextForegroundSet(&g_sContext, ClrWhite);
    GrRectDraw(&g_sContext, &sRect);

    //
    // Initialize the animation variables.
    //
    ui32AnimPos = ANIM_LEFT + 1;
    ui32Color = ClrRed;

    //
    // Initialize IO controls
    //
    io_init();    // Same as enet_io DEMO PROJECT

    EEPROM_Init();
    EEPROM_IPCfg(false, &IPConfig);


    //
    // Initialze the lwIP library, using static address found in EEPROM or the default one.
    //
    lwIPInit(g_ui32SysClock, IPConfig.MACAddr, IPConfig.IPAddress.addr,
    			IPConfig.IPSubnet.addr, IPConfig.IPGateway.addr, IPADDR_USE_STATIC);

    EMACPHYExtendedWrite(EMAC0_BASE, 0 , EPHY_LEDCR,
		(EMACPHYExtendedRead(EMAC0_BASE, 0 , EPHY_LEDCR) & ~ EPHY_LEDCR_BLINKRATE_M) |
		EPHY_LEDCR_BLINKRATE_20HZ);
	EMACPHYExtendedWrite(EMAC0_BASE, 0 , EPHY_LEDCFG,
		(EMACPHYExtendedRead(EMAC0_BASE, 0 , EPHY_LEDCFG) & ~ (EPHY_LEDCFG_LED0_M | EPHY_LEDCFG_LED1_M | EPHY_LEDCFG_LED2_M)) |
		EPHY_LEDCFG_LED0_LINK |
		EPHY_LEDCFG_LED1_TX |
		EPHY_LEDCFG_LED2_RX);

    //
    // Setup the device locator service.
    //
    LocatorInit();
    LocatorMACAddrSet(pui8MACArray);
    LocatorAppTitleSet("DK-TM4C129X enet_io");

    //
    // Initialize a sample httpd server.
    //
    httpd_init();

    //
    // Set the interrupt priorities.  We set the SysTick interrupt to a higher
    // priority than the Ethernet interrupt to ensure that the file system
    // tick is processed if SysTick occurs while the Ethernet handler is being
    // processed.  This is very likely since all the TCP/IP and HTTP work is
    // done in the context of the Ethernet interrupt.
    //
    ROM_IntPrioritySet(INT_EMAC0, ETHERNET_INT_PRIORITY);
    ROM_IntPrioritySet(FAULT_SYSTICK, SYSTICK_INT_PRIORITY);

    //
    // Pass our tag information to the HTTP server.
    //
    http_set_ssi_handler((tSSIHandler)SSIHandler, g_pcConfigSSITags,
                         NUM_CONFIG_SSI_TAGS);

    //
    // Pass our CGI handlers to the HTTP server.
    //
    http_set_cgi_handlers(g_psConfigCGIURIs, NUM_CONFIG_CGI_URIS);

   // PROGRAM THE FPGA HERE (code not written here...)

    //
    // Loop forever, processing the on-screen animation.  All other work is
    // done in the interrupt handlers.
    //
    while(1)
    {
        //
        // Wait for a new tick to occur.
        //
        while(!g_ulFlags)
        {
            //
            // Do nothing.
            //
        }

        if(PIN_BTN_SEL == 0)
        	bTest = FLH_TestPage(ui32AnimPos & 0x3F, 245, true);

        //
        // Clear the flag now that we have seen it.
        //
        HWREGBITW(&g_ulFlags, FLAG_TICK) = 0;

        //
        // Update the bar position and check for wrap.
        //
        ui32AnimPos ++;
        if(ui32AnimPos == ((ANIM_LEFT + ANIM_WIDTH) - 1))
        {
            //
            // We've reached the right edge so change color and move back
            // to the left.
            //
            ui32AnimPos = ANIM_LEFT + 1;
            ui32Color += COLOR_INCREMENT;
        }
        
        
        // Write dummy values in buffer
        uiTestArray[0] = 0;
        for (i = 1; i < 20; i++)
            uiTestArray[i] = uiTestArray[i-1] +1;
        
        // Write to FPGA in a loop
        for (i = 0; i < 20; i++)
         FPGA_PORT_16 = uiTestArray[i];

        //
        // Now we draw the new bar.  Note that we need to temporarily
        // disable the ethernet interrupt while doing this since we have
        // been naughty and set this app up so that it accesses the graphics
        // library from two different contexts.
        //
        ROM_IntDisable(INT_EMAC0);
        GrContextForegroundSet(&g_sContext, ui32Color);
        GrLineDrawV(&g_sContext, ui32AnimPos, (ANIM_TOP + 1),
                    (ANIM_TOP + ANIM_HEIGHT) - 2);
        ROM_IntEnable(INT_EMAC0);
    }
}