/*
 * pinout.h
 *
 *  Created on: 16.06.2015
 *      Author: Fou
 */

#ifndef DRIVERS_PINOUT_H_
#define DRIVERS_PINOUT_H_



//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

#define EPI_PORTA_PINS          GPIO_PIN_7 | GPIO_PIN_6	//
#define EPI_PORTB_PINS          GPIO_PIN_3 | GPIO_PIN_2	//
#define EPI_PORTC_PINS          GPIO_PIN_7 | GPIO_PIN_6 | GPIO_PIN_5 | GPIO_PIN_4	//
#define EPI_PORTD_PINS          0x00	//
#define EPI_PORTE_PINS          0x00	//
#define EPI_PORTF_PINS          0x00	//
#define EPI_PORTG_PINS          GPIO_PIN_1 | GPIO_PIN_0	//
#define EPI_PORTH_PINS          GPIO_PIN_3 | GPIO_PIN_2 | GPIO_PIN_1 | GPIO_PIN_0	//
#define EPI_PORTJ_PINS          0x00
#define EPI_PORTK_PINS          GPIO_PIN_5
#define EPI_PORTL_PINS          GPIO_PIN_4 | GPIO_PIN_3 | GPIO_PIN_2 | GPIO_PIN_1 | GPIO_PIN_0	//
#define EPI_PORTM_PINS          GPIO_PIN_3 | GPIO_PIN_2 | GPIO_PIN_1 | GPIO_PIN_0	//
#define EPI_PORTP_PINS          GPIO_PIN_3 | GPIO_PIN_2	//

// FPGA Address range (16 bits)
extern volatile unsigned short * epiFPGA;
// External RAM Address range (16 bits)
extern volatile unsigned short * epiSRAM; // Only used in HB16 mode

#define FPGA_PORT_16           epiFPGA[0x010]	// R/W	: test Register

#define PIN_FPGA_INIT		(HWREG(GPIO_PORTS_BASE	+ (GPIO_O_DATA + (GPIO_PIN_6 << 2))) >> 6)	// PS6
#define PIN_FPGA_DONE		(HWREG(GPIO_PORTT_BASE	+ (GPIO_O_DATA + (GPIO_PIN_1 << 2))) >> 1)	// PT1
#define POUT_FPGA_PROG		HWREG(GPIO_PORTT_BASE	+ (GPIO_O_DATA + (GPIO_PIN_0 << 2)))		// PT0
#define INDX_FPGA_PROG		(0x00000001 << 0)
#define POUT_FLASH_CS		HWREG(GPIO_PORTS_BASE	+ (GPIO_O_DATA + (GPIO_PIN_7 << 2)))		// PS7
#define INDX_FLASH_CS		(0x00000001 << 7)


// User LEDS for Test board
#define POUT_LED_R			HWREG(GPIO_PORTN_BASE	+ (GPIO_O_DATA + (GPIO_PIN_5 << 2)))		// PN5
#define PIN_LED_R			(HWREG(GPIO_PORTN_BASE	+ (GPIO_O_DATA + (GPIO_PIN_5 << 2))) >> 5)
#define INDX_LED_R			(0x00000001 << 5)
#define POUT_LED_G			HWREG(GPIO_PORTQ_BASE	+ (GPIO_O_DATA + (GPIO_PIN_7 << 2)))		// PQ7
#define PIN_LED_G			(HWREG(GPIO_PORTQ_BASE	+ (GPIO_O_DATA + (GPIO_PIN_7 << 2))) >> 7)
#define INDX_LED_G			(0x00000001 << 7)
#define POUT_LED_B			HWREG(GPIO_PORTQ_BASE	+ (GPIO_O_DATA + (GPIO_PIN_4 << 2)))		// PQ4
#define PIN_LED_B			(HWREG(GPIO_PORTQ_BASE	+ (GPIO_O_DATA + (GPIO_PIN_4 << 2))) >> 4)
#define INDX_LED_B			(0x00000001 << 4)

// Push buttons on the Test Board
#define PIN_BTN_SEL			(HWREG(GPIO_PORTP_BASE	+ (GPIO_O_DATA + (GPIO_PIN_1 << 2))) >> 1)	// PP1
#define PIN_BTN_UP			(HWREG(GPIO_PORTE_BASE	+ (GPIO_O_DATA + (GPIO_PIN_3 << 2))) >> 3)	// PE3
#define PIN_BTN_DN			(HWREG(GPIO_PORTE_BASE	+ (GPIO_O_DATA + (GPIO_PIN_5 << 2))) >> 5)	// PE5


// Port Power Enable pins definitions (1 to 12)
#define POUT_PWR_1			HWREG(GPIO_PORTJ_BASE	+ (GPIO_O_DATA + (GPIO_PIN_2 << 2)))		// PJ2
#define PIN_PWR_1			(HWREG(GPIO_PORTJ_BASE	+ (GPIO_O_DATA + (GPIO_PIN_2 << 2))) >> 2)
#define INDX_PWR_1			(0x00000001 << 2)
#define POUT_PWR_2			HWREG(GPIO_PORTB_BASE	+ (GPIO_O_DATA + (GPIO_PIN_4 << 2)))		// PB4
#define INDX_PWR_2			(0x00000001 << 4)
#define POUT_PWR_3			HWREG(GPIO_PORTJ_BASE	+ (GPIO_O_DATA + (GPIO_PIN_7 << 2)))		// PJ7
#define INDX_PWR_3			(0x00000001 << 7)
#define POUT_PWR_4			HWREG(GPIO_PORTN_BASE	+ (GPIO_O_DATA + (GPIO_PIN_0 << 2)))		// PN0
#define INDX_PWR_4			(0x00000001 << 0)
#define POUT_PWR_5			HWREG(GPIO_PORTN_BASE	+ (GPIO_O_DATA + (GPIO_PIN_1 << 2)))		// PN1
#define INDX_PWR_5			(0x00000001 << 1)
#define POUT_PWR_6			HWREG(GPIO_PORTN_BASE	+ (GPIO_O_DATA + (GPIO_PIN_2 << 2)))		// PN2
#define INDX_PWR_6			(0x00000001 << 2)
#define POUT_PWR_7			HWREG(GPIO_PORTE_BASE	+ (GPIO_O_DATA + (GPIO_PIN_3 << 2)))		// PE3
#define INDX_PWR_7			(0x00000001 << 3)
#define POUT_PWR_8			HWREG(GPIO_PORTE_BASE	+ (GPIO_O_DATA + (GPIO_PIN_6 << 2)))		// PE6
#define INDX_PWR_8			(0x00000001 << 6)
#define POUT_PWR_9			HWREG(GPIO_PORTK_BASE	+ (GPIO_O_DATA + (GPIO_PIN_0 << 2)))		// PK0
#define INDX_PWR_9			(0x00000001 << 0)
#define POUT_PWR_10			HWREG(GPIO_PORTK_BASE	+ (GPIO_O_DATA + (GPIO_PIN_1 << 2)))		// PK1
#define INDX_PWR_10			(0x00000001 << 1)
#define POUT_PWR_11			HWREG(GPIO_PORTK_BASE	+ (GPIO_O_DATA + (GPIO_PIN_2 << 2)))		// PK2
#define INDX_PWR_11			(0x00000001 << 2)
#define POUT_PWR_12			HWREG(GPIO_PORTK_BASE	+ (GPIO_O_DATA + (GPIO_PIN_3 << 2)))		// PK3
#define INDX_PWR_12			(0x00000001 << 3)

//*****************************************************************************
//
// Prototypes.
//
//*****************************************************************************
extern void PinoutSet(uint32_t SystemClk);

#endif /* DRIVERS_PINOUT_H_ */
