/** @file HL_sys_main.c
 *   @brief Application main file
 *   @date 11-Dec-2018
 *   @version 04.07.01
 *
 *   This file contains an empty main function,
 *   which can be used for the application.
 */

/*
 * Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
#include "HL_sci.h"
#include "HL_sys_dma.h"
#include "stdio.h"

/* USER CODE END */

/** @fn void main(void)
 *   @brief Application main function
 *   @note This function is empty by default.
 *
 *   This function is called after startup.
 *   The user can use this function to implement the application.
 */

/* USER CODE BEGIN (2) */
#define size 100

/* Tx and Rx data buffer */
uint8_t TX_DATA[size], RX_DATA[size] = {0};

#define SCI1_TX_ADDR ((uint32_t)(&(sciREG1->TD)) + 3)
#define SCI2_TX_ADDR ((uint32_t)(&(sciREG2->TD)) + 3)
#define SCI3_TX_ADDR ((uint32_t)(&(sciREG3->TD)) + 3)
#define SCI4_TX_ADDR ((uint32_t)(&(sciREG4->TD)) + 3)

#define DMA_SCI1_TX DMA_REQ29
#define DMA_SCI2_TX DMA_REQ41
#define DMA_SCI3_TX DMA_REQ31
#define DMA_SCI4_TX DMA_REQ43

#define SCI_SET_TX_DMA (1 << 16)
#define SCI_SET_RX_DMA (1 << 17)
#define SCI_SET_RX_DMA_ALL (1 << 18)
/* USER CODE END */

int main(void) {
  /* USER CODE BEGIN (3) */
  uint32 sciTxData;
  int i;
  g_dmaCTRL g_dmaCTRLPKT1;


  /*Load source data*/
  for (i = 0; i < size; i++) {
    TX_DATA[i] = i;
  }

  /*Initialize SCI*/
  sciInit();

  while (((sciREG1->FLR & SCI_TX_INT) == 0U) || ((sciREG1->FLR & 0x4) == 0x4)) {
  } /* Wait */

  /*Assign DMA request SCI3 transmit to Channel 0*/
  dmaReqAssign(DMA_CH5, DMA_SCI1_TX);
  dmaReqAssign(DMA_CH6, DMA_SCI2_TX);
  dmaReqAssign(DMA_CH7, DMA_SCI3_TX);
  dmaReqAssign(DMA_CH8, DMA_SCI4_TX);

  sciTxData = SCI1_TX_ADDR;

  /*Configure control packet for Channel 0*/
  g_dmaCTRLPKT1.SADD = (uint32_t)TX_DATA; /* source address             */
  g_dmaCTRLPKT1.DADD = sciTxData;         /* destination  address       */
  g_dmaCTRLPKT1.CHCTRL = 0;               /* channel control            */
  g_dmaCTRLPKT1.FRCNT = size;             /* frame count                */
  g_dmaCTRLPKT1.ELCNT = 1;                /* element count              */
  g_dmaCTRLPKT1.ELDOFFSET = 0;            /* element destination offset */
  g_dmaCTRLPKT1.ELSOFFSET = 0;            /* element destination offset */
  g_dmaCTRLPKT1.FRDOFFSET = 0;            /* frame destination offset   */
  g_dmaCTRLPKT1.FRSOFFSET = 0;            /* frame destination offset   */
  g_dmaCTRLPKT1.PORTASGN = PORTA_READ_PORTB_WRITE;
  g_dmaCTRLPKT1.RDSIZE = ACCESS_8_BIT;   /* read size                  */
  g_dmaCTRLPKT1.WRSIZE = ACCESS_8_BIT;   /* write size                 */
  g_dmaCTRLPKT1.TTYPE = FRAME_TRANSFER;  /* transfer type              */
  g_dmaCTRLPKT1.ADDMODERD = ADDR_INC1;   /* address mode read          */
  g_dmaCTRLPKT1.ADDMODEWR = ADDR_FIXED;  /* address mode write         */
  g_dmaCTRLPKT1.AUTOINIT = AUTOINIT_OFF; /* autoinit                   */

  /*Set control packet for channel 0 and 1*/
  dmaSetCtrlPacket(DMA_CH5, g_dmaCTRLPKT1);

  /*Set dma channel 0 and 1 to trigger on hardware request*/
  dmaSetChEnable(DMA_CH5, DMA_HW);

  /*Enable DMA*/
  dmaEnable();

  /*Enable SCI3 Transmit and SCI4 Receive DMA Request*/
  sciREG1->SETINT |= SCI_SET_TX_DMA;

  while (1)
    ;

  /* USER CODE END */

  return 0;
}

/* USER CODE BEGIN (4) */
/* USER CODE END */
