/*
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== empty.c ========
 */
/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/System.h>
#include <xdc/cfg/global.h>
/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>

/* TI-RTOS Header files */
// #include <ti/drivers/EMAC.h>
#include <ti/drivers/GPIO.h>
// #include <ti/drivers/I2C.h>
// #include <ti/drivers/SDSPI.h>
#include <ti/drivers/SPI.h>
// #include <ti/drivers/SSI.h>
// #include <ti/drivers/USBMSCHFatFs.h>
// #include <ti/drivers/Watchdog.h>
// #include <ti/drivers/WiFi.h>

#include <ti/sysbios/knl/Semaphore.h>
/* Board Header file */
#include "Board.h"
#include <ti/sysbios/knl/Swi.h>
#include <xdc/runtime/Error.h>
#include <ti/sysbios/family/arm/m3/Hwi.h>

#include <stdbool.h>
#include "driverlib/sysctl.h"
#include "driverlib/ssi.h"
#include "driverlib/udma.h"
#include "driverlib/interrupt.h"
#include <inc/hw_memmap.h>
#include <inc/hw_ints.h>
#include "inc/hw_ssi.h"
#include <stdbool.h>
#include <ti/sysbios/knl/Event.h>
#include <xdc/runtime/Error.h>
#include <ti/sysbios/utils/Load.h>
#include <ti/sysbios/knl/Swi.h>
#include <string.h>

#define TASKSTACKSIZE   512

#define SSI_TXBUF_SIZE          64

uint8_t pui8ControlTable[1024];
uint8_t DMATxBuffer[SSI_TXBUF_SIZE];
uint8_t DMASendbuf[SSI_TXBUF_SIZE];
Task_Struct task0Struct;
Task_Struct task1Struct;



Char task0Stack[TASKSTACKSIZE];


Event_Handle Event_RxISR_Operation;
/* Error Block  Handler*/
Error_Block eb;

bool transferOK = FALSE;
uint32_t ui32IntStatus;

//*****************************************************************************
//
// The interrupt handler for SSI0.
//
//*****************************************************************************

printreceivedbuf(uint8_t *data)
{
	uint8_t i = 0;

	for(i = 0;i < SSI_TXBUF_SIZE; i++)
	{
		System_printf("%x", *(data + i));

	}
	System_flush();
	System_printf("\n");

}
void SSI0IntHandler(void)
{
    uint32_t ui32Status;
//    uint32_t uiInt32Status;
    //
	// Read the interrupt status of the SSI.
	//
//    uiInt32Status = SSIIntStatus(SSI0_BASE, FALSE);
    ui32Status = SSIIntStatus(SSI0_BASE, TRUE);
	//
	// Clear any pending status, even though there should be none since no SSI
	// interrupts were enabled.  If SSI error interrupts were enabled, then
	// those interrupts could occur here and should be handled.  Since uDMA is
	// used for both the RX and TX, then neither of those interrupts should be
	// enabled.
	//
	SSIIntClear(SSI0_BASE, ui32Status);

	Event_post(Event_RxISR_Operation, Event_Id_00);

	if(!uDMAChannelIsEnabled(UDMA_CHANNEL_SSI0TX))
	{

		uDMAChannelTransferSet(UDMA_CHANNEL_SSI0TX | UDMA_PRI_SELECT,
									UDMA_MODE_BASIC, DMATxBuffer,
									   (void *)(SSI0_BASE + SSI_O_DR),
									   SSI_TXBUF_SIZE);

		uDMAChannelEnable(UDMA_CHANNEL_SSI0TX);
	}
}




//*****************************************************************************
//
// Initializes the SSI0 transfer
//
//*****************************************************************************
void
InitSSI0Transfer(void)
{
	uint16_t ui8Idx = 0;

	//
	// Fill the TX buffer with a simple data pattern.
	//
	for(ui8Idx = 0; ui8Idx < SSI_TXBUF_SIZE; ui8Idx++)
	{
		DMATxBuffer[ui8Idx] = ui8Idx + 1;

	}

    /* SSI 0 Configuration */
	SysCtlPeripheralEnable(SYSCTL_PERIPH_SSI0);
	SysCtlPeripheralSleepEnable(SYSCTL_PERIPH_SSI0);

    //
    // Configure the SSI communication parameters.
    //
    SSIConfigSetExpClk(SSI0_BASE, 120000000 /* SysCtlClockGet() */, SSI_FRF_MOTO_MODE_0,
    					SSI_MODE_MASTER, 4000000, 8);

    //
    // Enable the SSI for operation, and enable the uDMA interface for both TX
    // and RX channels.
    //
    SSIEnable(SSI0_BASE);

    SSIDMAEnable(SSI0_BASE, SSI_DMA_TX);

    SSIClockSourceSet(SSI0_BASE, SSI_CLOCK_PIOSC);
	 //
	 // Enable the SSI peripheral, and configure it to operate even if the CPU
	 // is in sleep.
	 //
	 SysCtlPeripheralEnable(SYSCTL_PERIPH_UDMA);
	 SysCtlPeripheralSleepEnable(SYSCTL_PERIPH_UDMA);

	 //
	 // Enable the uDMA controller.
	 //
	 uDMAEnable();

	 //
	 // Point at the control table to use for channel control structures.
	 //
	 uDMAControlBaseSet(pui8ControlTable);


    //
    // Put the attributes in a known state for the uDMA SSI1RX channel.  These
    // should already be disabled by default.
    //
    uDMAChannelAttributeDisable(UDMA_CHANNEL_SSI0TX, UDMA_ATTR_USEBURST | UDMA_ATTR_REQMASK | UDMA_ATTR_HIGH_PRIORITY );

//    uDMAChannelAttributeEnable(UDMA_CHANNEL_SSI0TX, UDMA_ATTR_USEBURST);

    //
	// Configure the control parameters for the SSI TX.  The uDMA SSI TX
	// channel is used to transfer a block of data from a buffer to the SSI.
	// The data size is 8 bits.  The source address increment is 8-bit bytes
	// since the data is coming from a buffer.  The destination increment is
	// none since the data is to be written to the SSI data register.  The
	// arbitration size is set to 4, which matches the SSI TX FIFO trigger
	// threshold.
	//
	uDMAChannelControlSet(UDMA_CHANNEL_SSI0TX | UDMA_PRI_SELECT,
							  UDMA_SIZE_8 | UDMA_SRC_INC_8 |
							  UDMA_DST_INC_NONE |
							  UDMA_ARB_8);

	//
	// Set up the transfer parameters for the uDMA SSI TX channel.  This will
	// configure the transfer source and destination and the transfer size.
	// Basic mode is used because the peripheral is making the uDMA transfer
	// request.  The source is the TX buffer and the destination is the SSI
	// data register.
	//
	uDMAChannelTransferSet(UDMA_CHANNEL_SSI0TX | UDMA_PRI_SELECT,
							UDMA_MODE_BASIC, DMATxBuffer,
							   (void *)(SSI0_BASE + SSI_O_DR),
							   SSI_TXBUF_SIZE);


	uDMAChannelEnable(UDMA_CHANNEL_SSI0TX);

	//
	// Enable the SSI DMA TX/RX interrupts.
	//
	SSIIntEnable(SSI0_BASE, SSI_DMATX);

	SSIIntRegister(SSI0_BASE, SSI0IntHandler);

}


void ioc_RxTask(UArg arg0, UArg arg1)
{

	InitSSI0Transfer();
    while (1) {
    	Event_pend(Event_RxISR_Operation, Event_Id_00 ,
    								Event_Id_NONE, BIOS_WAIT_FOREVER);

    	GPIO_toggle(Board_LED1);

     	Task_sleep((unsigned int)arg0);
//    	System_printf("v : %d\n", ActivePage);
//    	System_flush();
    }
}


/*
 *  ======== main ========
 */
int main(void)
{
    Task_Params taskParams;
    /* Call board init functions */
    Board_initGeneral();
    // Board_initEMAC();
    Board_initGPIO();
    // Board_initI2C();
    // Board_initSDSPI();
    Board_initSPI();

    //Board_initSSI();
    // Board_initUSB(Board_USBDEVICE);
    // Board_initUSBMSCHFatFs();
    // Board_initWatchdog();
    // Board_initWiFi();

	/* Error Block Handler */
	Error_init(&eb);

	/* Event created for ISR */
	Event_RxISR_Operation = Event_create(NULL, &eb);
	if (Event_RxISR_Operation == NULL)
	{
	System_abort("Event create failed");
	}

    /* Construct heartBeat Task  thread */
    Task_Params_init(&taskParams);
    taskParams.arg0 = 1000;
    taskParams.stackSize = TASKSTACKSIZE;
    taskParams.stack = &task0Stack;
    Task_construct(&task0Struct, (Task_FuncPtr)ioc_RxTask, &taskParams, NULL);

    /* Start BIOS */
    BIOS_start();

    return (0);
}
