/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
#include "bl_flash.h"
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "gio.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
#define SIZE 4//16
uint8_t dataToProgram[SIZE] =   {0, 1, 2, 3};//, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};

#define BANK0   0
#define START_ADDRESS  0x00010000

extern unsigned int apiLoadStart;
extern unsigned int apiLoadSize;
extern unsigned int apiRunStart;


extern unsigned int constLoadStart;
extern unsigned int constLoadSize;
extern unsigned int constRunStart;
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    /* Copy the flash APIs to SRAM*/
    //_copyAPI2RAM_(&apiLoadStart, &apiRunStart, &apiLoadSize);
    memcpy(&apiRunStart, &apiLoadStart, (uint32)&apiLoadSize);

    /* Copy the .const section */
    //_copyAPI2RAM_(&constLoadStart, &constRunStart, &constLoadSize);
    memcpy(&constRunStart, &constLoadStart, (uint32)&constLoadSize);

    Fapi_Init(BANK0, BANK0);
    Fapi_BlockErase(START_ADDRESS, SIZE);
    Fapi_BlockProgram(START_ADDRESS, (uint32_t)dataToProgram, SIZE);

    gioInit();

    gioSetBit(gioPORTB,1,0);
    gioSetBit(gioPORTB,2,1);

    while(1)
    {
        unsigned int i,j,x;

        for (i=0;i<600000;i++)
        {
            for (j=0;j<15;j++)
            {
                gioToggleBit(gioPORTB,2);

            }

        }
        gioToggleBit(gioPORTB,1);

        j=0;


    }
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
/* USER CODE END */
