////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Fee.c
//
// Description: FlashEEprom - Flash emulation of EEprom.  
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Files--------------------------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "Fee.h"

// Library Files

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Local Definitions----------------------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Types  (typedef / enum / struct / union)-----------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Static Variables (File Scope) referenced in Global Variables---------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Global Variables (extern & non-static)-------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Static Variables (File Scope)----------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Local Prototypes-----------------------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void fee_delay (void);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Public Functions-----------------------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Name:	Fee_Init
// Desc:	
// Notes:	
// Globals:	none
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void Fee_Init (void)
{
	uint16 sts;

	// Initialize FEE. This will create Virtual sectors, initialize global variables etc.
	TI_Fee_Init ();
	do
	{
		TI_Fee_MainFunction ();
		fee_delay ();
// with either exported-image1.bin or exported-image2.bin or exported-image3.bin programmed into flash bank7, 
// TI_Fee_GlobalVariables[0].Fee_Error wiil be Error_TwoCopyVS error code.
		if (TI_Fee_GlobalVariables[0].Fee_Error != Error_Nil)
		{
// uncomment line below only to recover from exported-image1.bin and exported-image2.bin but not exported-image3.bin
//			TI_Fee_ErrorRecovery(TI_Fee_GlobalVariables[0].Fee_Error, TI_Fee_GlobalVariables[0].Fee_u8ActiveVirtualSector);
// uncomment line below to recover from any of exported-images. 
//            TI_Fee_ErrorRecovery(TI_Fee_GlobalVariables[0].Fee_Error, TI_Fee_GlobalVariables[0].Fee_u8CopyVirtualSector);
		}
		sts = TI_Fee_GetStatus (0);
	}
	while(sts != IDLE);
}//--end void Fee_Init (void)


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Accessor Functions---------------------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Local Functions------------------------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Name:	
// Desc:	
// Notes:	
// Globals:	none
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void fee_delay (void)
{
	unsigned int dummycnt = 0x0000FFU;

	do
	{
		dummycnt--;
	}    while (dummycnt > 0);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Name:	
// Desc:	
// Notes:	
// Globals:	none
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

