/*
* TRAGET MCU NAME: TM4C123GH6PM
* 11/4/2021
* SYSTEM CINTROL DREIVE   PAGE 212
* #include"SYSCRL_config.h"
*
*
*/
/*Register 3: Brown-Out Reset Control (PBORCTL PAGE */
/*u8 POWER_VOLTAGE */
typedef enum
{
	_3_02TYPE,
	_2_88TYPE,
}BRO_TYPE;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*u8 EVENT*/
typedef enum
{
	INTI,
	RESET,
}event_types;

//////////////////////////////////////////////////
/*Register 8: Run-Mode Clock Configuration (RCC), offset 0x060 page 254*/
/*void SYSCRL_INTI()*/
/*PLL_USEADGE   options

PLL_USED
PLL_NOT_USED

*/
typedef enum
{
	PLL_USED,
	PLL_NOT_USED,
}PLL_OPS;
#define  PLL_USEADGE      PLL_NOT_USED
/////////////////////////////////////////////////////////////////////////////////////////////////////    

/* CRY_VAL  options    XTAL
USE4MHZ              // NOT USING PLL
USE4_096MHZ          // NOT USING PLL
USE4_9152MHZ         // NOT USING PLL
USE5MHZ              // NOT USING PLL    AND    PLL     AND USB
USE5_12MHZ           // NOT USING PLL    AND    PLL     
USE6MHZ              // NOT USING PLL    AND    PLL     AND USB
USE6_144MHZ          // NOT USING PLL    AND    PLL     
USE7_372MHZ          // NOT USING PLL    AND    PLL
USE8MHZ              // NOT USING PLL    AND    PLL
USE8_192MHZ          // NOT USING PLL    AND    PLL
USE10MHZ             // NOT USING PLL    AND    PLL     AND USB
USE12MHZ             // NOT USING PLL    AND    PLL     AND USB
USE12_288MHZ         // NOT USING PLL    AND    PLL     AND USB
USE13_56MHZ          // NOT USING PLL    AND    PLL
USE14_318MHZ         // NOT USING PLL    AND    PLL
USE16MHZ             // NOT USING PLL    AND    PLL 
USE16_384MHZ         // NOT USING PLL    AND    PLL 
USE18MHZ             // NOT USING PLL    AND    PLL     AND USB
USE20MHZ             // NOT USING PLL    AND    PLL     AND USB
USE24MHZ             // NOT USING PLL    AND    PLL     AND USB
USE25MHZ             // NOT USING PLL    AND    PLL     AND USB

*/
typedef enum
{
	USE4MHZ,
	USE4_096MHZ,
	USE4_9152MHZ,
	USE5MHZ,
	USE5_12MHZ,
	USE6MHZ,
	USE6_144MHZ,
	USE7_372MHZ,          // NOT USING PLL    AND    PLL
    USE8MHZ,              // NOT USING PLL    AND    PLL
    USE8_192MHZ,          // NOT USING PLL    AND    PLL
    USE10MHZ,             // NOT USING PLL    AND    PLL     AND USB
    USE12MHZ,             // NOT USING PLL    AND    PLL     AND USB
    USE12_288MHZ,         // NOT USING PLL    AND    PLL     AND USB
    USE13_56MHZ,          // NOT USING PLL    AND    PLL
    USE14_318MHZ,         // NOT USING PLL    AND    PLL
    USE16MHZ,             // NOT USING PLL    AND    PLL
    USE16_384MHZ ,        // NOT USING PLL    AND    PLL
    USE18MHZ,             // NOT USING PLL    AND    PLL     AND USB
    USE20MHZ,             // NOT USING PLL    AND    PLL     AND USB
    USE24MHZ,             // NOT USING PLL    AND    PLL     AND USB
    USE25MHZ,
}XTAL_OPS;
#define CRY_VAL        USE4MHZ        
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*OSC_VAL  options
MOSC      // Main oscillator
PIOSC     // Precision internal oscillator
PIOSC_4   // Precision internal oscillator / 4
LFIOSC    // Low-frequency internal oscillator

*/
typedef enum
{
   MOSC,      // Main oscillator
   PIOSC,     // Precision internal oscillator
   PIOSC_4,   // Precision internal oscillator / 4
   LFIOSC ,   // Low-frequency internal oscillator
}OSC_VAL_OPS;

#define   OSC_VAL         PIOSC
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*SYS_DEVIDER options   IN SYSDIV  IN RCC
//OPTIONS             Frequency (BYPASS=1)       Frequency (BYPASS=0)    Divisor
SYSCTL_SYSDIV_1   |  Clock source frequency/1         reserved             /1
SYSCTL_SYSDIV_2   |  Clock source frequency/2         reserved             /2 
SYSCTL_SYSDIV_3   |  Clock source frequency/3         66.67 MHz            /3
SYSCTL_SYSDIV_4   |  Clock source frequency/4         50 MHz               /4
SYSCTL_SYSDIV_5   |  Clock source frequency/5         40 MHz               /5
SYSCTL_SYSDIV_6   |  Clock source frequency/6         33.33 MHz            /6
SYSCTL_SYSDIV_7   |  Clock source frequency/7         28.57 MHz            /7       
SYSCTL_SYSDIV_8   |  Clock source frequency/8         25 MHz               /8
SYSCTL_SYSDIV_9   |  Clock source frequency/9         22.22 MHz            /9
SYSCTL_SYSDIV_10  |  Clock source frequency/10        20 MHz               /10
SYSCTL_SYSDIV_11  |  Clock source frequency/11        18.18 MHz            /11
SYSCTL_SYSDIV_12  |  Clock source frequency/12        16.67 MHz            /12
SYSCTL_SYSDIV_13  | Clock source frequency/13        15.38 MHz            /13
SYSCTL_SYSDIV_14  |  Clock source frequency/14        14.29 MHz            /14
SYSCTL_SYSDIV_15  |  Clock source frequency/15        13.33 MHz            /15
SYSCTL_SYSDIV_16  |  Clock source frequency/16        12.5 MHz             /16 
*/

typedef enum 
{
//     OPTIONS               Frequency (BYPASS=1)        Frequency (BYPASS=0)    Divisor	
	SYSCTL_SYSDIV__1,  // |  Clock source frequency/1         reserved             /1
    SYSCTL_SYSDIV__2,  // |  Clock source frequency/2         reserved             /2
    SYSCTL_SYSDIV__3,  // |  Clock source frequency/3         66.67 MHz            /3
    SYSCTL_SYSDIV__4,  // |  Clock source frequency/4         50 MHz               /4
    SYSCTL_SYSDIV__5,  // |  Clock source frequency/5         40 MHz               /5
    SYSCTL_SYSDIV__6,  // |  Clock source frequency/6         33.33 MHz            /6
    SYSCTL_SYSDIV__7,  // |  Clock source frequency/7         28.57 MHz            /7
    SYSCTL_SYSDIV__8,  // |  Clock source frequency/8         25 MHz               /8
    SYSCTL_SYSDIV__9,  // |  Clock source frequency/9         22.22 MHz            /9
    SYSCTL_SYSDIV__10, // |  Clock source frequency/10        20 MHz               /10
    SYSCTL_SYSDIV__11, // |  Clock source frequency/11        18.18 MHz            /11
    SYSCTL_SYSDIV__12, // |  Clock source frequency/12        16.67 MHz            /12
    SYSCTL_SYSDIV__13, // | Clock source frequency/13        15.38 MHz            /13
    SYSCTL_SYSDIV__14, // |  Clock source frequency/14        14.29 MHz            /14
    SYSCTL_SYSDIV__15, // |  Clock source frequency/15        13.33 MHz            /15
    SYSCTL_SYSDIV__16, // |  Clock source frequency/16        12.5 MHz             /16
}SYS_DEVIDER;

#define SYS_DEVIDER   SYSCTL_SYSDIV_3    
     
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*Register 9: GPIO High-Performance Bus Control (GPIOHBCTL), offset 0x06C
GPIO_PORT PARAMETER*/
typedef enum
{
	APB,
	AHB,
}PERBUS;
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*Register 60: General-Purpose Input/Output Run Mode Clock Gating Control
(RCGCGPIO), offset 0x608 page 340*/
/*u8 GPIO_PORT*/
typedef enum
{
	PORTA,
	PORTB,
	PORTC,
	PORTD,
	PORTE,
	PORTF,
}EPORTS;

///////////////////////////////////////////////////////////////////////////////////////////////
















