/*
* TRAGET MCU NAME: TM4C123GH6PM
* 11/4/2021
* SYSTEM CINTROL DREIVE   PAGE 212
* #include"SYSCRL_interface.h"
*
*
*/
#ifndef SYSCRL_INTERFACE_H
#define SYSCRL_INTERFACE_H
/*register Pins*/
/*Device Identification 0 (DID0), page 238*/

/*Device Identification 1 (DID0), page 240*/

/*Register 3: Brown-Out Reset Control (PBORCTL), offset 0x030 page 243*/
/*This register is responsible for controlling reset conditions after
 initial power-on reset.*/
 
#define BOR1  1//VDD under BOR0 Event ActionThe VDD BOR0 trip value is 3.02V +/- 90mv.
#define BOR2  2//VDD under BOR1 Event ActionThe VDD BOR1 trip value is 2.88V +/- 90mv.
////////////////////////////////////////////////////////////////////////////////
/*Register 4: Raw Interrupt Status (RIS), offset 0x050 page 244*/
/*u8 INTRRUPT_STATUSE_BIT ARGUMENT*/
#define BOR1RIS          1//VDD under BOR1 Raw Interrupt Status
#define MOFRIS           3//Main Oscillator Failure Raw Interrupt Status
#define PLLLRIS          6//PLL Lock Raw Interrupt Status
#define USBPLLLRIS       7//USB PLL Lock Raw Interrupt Status
#define MOSCPUPRIS       8//MOSC Power Up Raw Interrupt Status
#define VDDARIS          10//VDDA Power OK Event Raw Interrupt Status
#define BOR0RIS          11//VDD under BOR0 Raw Interrupt Status
//////////////////////////////////////////////////////////////////////////////
/*Register 5: Interrupt Mask Control (IMC), offset 0x054 page 247*/
/* u8 INTRRUPT_MASK_SET ARGUMENT */
#define BOR0IM        11    //VDD under BOR0 Interrupt Mask
#define VDDAIM        10    //VDDA Power OK Interrupt Mask
#define MOSCPUPIM      8    //MOSC Power Up Interrupt Mask
#define USBPLLLIM      7    //USB PLL Lock Interrupt Mask
#define PLLLIM         6    //PLL Lock Interrupt Mask
#define MOFIM          3    //Main Oscillator Failure Interrupt Mask
#define BOR1IM         1    //VDD under BOR1 Interrupt Mask
////////////////////////////////////////////////////////////////
/*Register 6: Masked Interrupt Status and Clear (MISC), offset 0x058*/
#define BOR0MIS      11    // VDD under BOR0 Masked Interrupt Status
#define VDDAMIS      10    // VDDA Power OK Masked Interrupt Status
#define MOSCPUPMIS    8    // MOSC Power Up Masked Interrupt Status
#define USBPLLLMIS    7    // USB PLL Lock Masked Interrupt Status
#define PLLLMIS       6    // PLL Lock Masked Interrupt Status
#define MOFMIS        3    // Main Oscillator Failure Masked Interrupt Status
#define BOR1MIS       1    // VDD under BOR1 Masked Interrupt Status
///////////////////////////////////////////////////////////////////
/*Register 7: Reset Cause (RESC), offset 0x05C PAGE 252*/
/*u8 RESET_EVENT*/
#define   MOSCFAIL     16    //MOSC Failure Reset
#define   WDT1          5    //Watchdog Timer 1 Reset
#define   SW            4    //Software Reset
#define   WDT0          3    //Watchdog Timer 0 Reset
#define   BOR           2    //Brown-Out Reset
#define   POR           1    //Power-On Reset
#define   EXT           0    //External Reset
/////////////////////////////////////////////////////////////////////
/*Register 8: Run-Mode Clock Configuration (RCC), offset 0x060 page 254*/
#define   ACG          27       //Auto Clock Gating
#define   SYSDIV       23       //System Clock Divisor
#define   USESYSDIV    22       //Enable System Clock Divider
#define   USEPWMDIV    20       //Enable PWM Clock Divisor
#define   PWMDIV       17       //PWM Unit Clock Divisor
#define   PWRDN        13       //PLL Power Down   
#define   BYPASS       11       //PLL Bypass  
#define   XTAL          6       //Crystal Value
#define   OSCSRC        4       //Oscillator Source
#define   MOSCDIS       0       //Main Oscillator Disable
///////////////////////////////////////////////////////////////////
/*Register 9: GPIO High-Performance Bus Control (GPIOHBCTL), offset 0x06C*/

#define   PORTF        5        // Port F Advanced High-Performance Bus 
#define   PORTE        4        // Port E Advanced High-Performance Bus
#define   PORTD        3        // Port D Advanced High-Performance Bus 
#define   PORTC        2        // Port C Advanced High-Performance Bus 
#define   PORTB        1        // Port B Advanced High-Performance Bus 
#define   PORTA        0        // Port A Advanced High-Performance Bus 
///////////////////////////////////////////////////////////////////////////////
/*Register 10: Run-Mode Clock Configuration 2 (RCC2), offset 0x070 page 255*/

#define  USERCC2      31       // Use RCC2
#define  DIV400       30       // Divide PLL as 400 MHz versus 200 MHz
#define  SYSDIV2      23       // System Clock Divisor 2
#define  SYSDIV2LSB   22       // Additional LSB for SYSDIV2
#define  USBPWRDN     14       // Power-Down USB PLL  
#define  PWRDN2       13       // Power-Down PLL 2
#define  BYPASS2      11       // PLL Bypass 2
#define  OSCSRC2      4        // Oscillator Source 2 
/////////////////////////////////////////////////////////////////////////
/*Register 9: GPIO High-Performance Bus Control (GPIOHBCTL), offset 0x06C
page 258 */
#define    PORTA       0
#define    PORTB       1
#define    PORTC       2
#define    PORTD       3
#define    PORTE       4
#define    PORTF       5






////////////////////////////////SERVIES////////////////////////////
void BROWN_OUT_EVENT_SELECT(u8 POWER_VOLTAGE , u8 EVENT);
u8 GET_INTERRUPT_STATUS(u8 INTRRUPT_STATUSE_BIT);
void SET_INTERRUPT_CTRL(u8 INTRRUPT_MASK);
void CLR_INTERRUPT_CTRL(u8 INTRRUPT_MASK_CLR);
u8 GET_UNMASKED_INTRRUPT(u8 INTRRUPT_MASK_CLR);
u8 READ_RESET_EVENT(u8 RESET_EVENT);
void SYSCRL_INTI(void);
void  GPIO_PERFORMANCE_BUS(u8 PERF_BUS , u8 GPIO_PORT);
void ENABLE_GPIO_CLOCK( u8 GPIO_PORT );
void ENABLE_GPIO_CLOCK_SLEEP_MODE( u8 GPIO_PORT );
void ENABLE_GPIO_CLOCK_DEEP_SLEEP_MODE( u8 GPIO_PORT );





 




#endif /*SYSCRL_INTERFACE_H*/
