/*
* TRAGET MCU NAME: TM4C123GH6PM
* 11/4/2021
* SYSTEM CINTROL DREIVE   PAGE 212
* Versoin : 0
*
*
*/
#include"types.h"
#include"bitwise.h"
#include"SYSCRL_private.h"
#include"SYSCRL_config.h"
#include"SYSCRL_interface.h"

void BROWN_OUT_EVENT_SELECT(u8 POWER_VOLTAGE , u8 EVENT)
{
	if(POWER_VOLTAGE==_2_88TYPE)
	{
		switch (EVENT)
		{
			case INTI  : SYSCRL0->PBORCTL &= ~(1<<BOR1);break;
			case RESET : SYSCRL0->PBORCTL |=  (1<<BOR1);break; 
			default: /*Donothing*/ break;
		}
	}
	else if (POWER_VOLTAGE==_3_02TYPE)
	{
		switch (EVENT)
		{
			case INTI  : SYSCRL0->PBORCTL &= ~(1<<BOR2);break;
			case RESET : SYSCRL0->PBORCTL |=  (1<<BOR2);break;
			default: /*Donothing*/ break;
		}
	}
	else
	{
		/*Do No thing*/
	}
}

u8 GET_INTERRUPT_STATUS(u8 INTRRUPT_STATUSE_BIT)
{
	u8 BIT_STATE = 0 ;
	BIT_STATE = GET_BIT(SYSCRL0->RIS,INTRRUPT_STATUSE_BIT);
	return BIT_STATE;
}


void SET_INTERRUPT_CTRL(u8 INTRRUPT_MASK_SET)
{
	SET_BIT(SYSCRL0->IMC,INTRRUPT_MASK_SET);
}

void CLR_INTERRUPT_CTRL(u8 INTRRUPT_MASK_CLR)
{
	SET_BIT(SYSCRL0->MISC,INTRRUPT_MASK_CLR);
}

u8 GET_UNMASKED_INTRRUPT(u8 INTRRUPT_MASK_CLR)
{
	u8 CLR_MASKE = 0;
	CLR_MASKE = GET_BIT(SYSCRL0->MISC,INTRRUPT_MASK_CLR);
	return  CLR_MASKE ;
}

u8 READ_RESET_EVENT(u8 RESET_EVENT)
{
	u8 EVENT_RESET = 0 ;
	   EVENT_RESET =  GET_BIT(SYSCRL0->RESC,RESET_EVENT);
	   return  EVENT_RESET ;
}

void RESET_INTRRUPT(u8 RESET_EVENT)
{
	SET_BIT(SYSCRL0->RESC,RESET_EVENT);
}



void SYSCRL_INTI(void)
{

	#if PLL_USEADGE  ==  PLL_USED
    (SYSCRL0->RCC)=0b00000000000000000000100000000000;
//	(SYSCRL0->RCC)|=(1<<(BYPASS));
//	(SYSCRL0->RCC)&=~(1<<(USESYSDIV));
//	(SYSCRL0->RCC)&=~(1<<(MOSCDIS));
//	(SYSCRL0->RIS)|=(1<<(MOSCPUPRIS));
    while(!(GET_BIT(SYSCRL0->RIS,MOSCPUPRIS)));
	///////////////XTAL///////////////////
	  #if   CRY_VAL == USE5MHZUSB
	    (SYSCRL0->RCC)|=(9<<(XTAL));
	  #elif CRY_VAL == USE5_12MHZ
	    (SYSCRL0->RCC)|=(0x0A<<(XTAL));
	  #elif CRY_VAL == USE6MHZ
	    (SYSCRL0->RCC)|=(0x0B<<(XTAL));
	  #elif CRY_VAL == USE6_144MHZ
	    (SYSCRL0->RCC)|=(0x0C<<(XTAL));
	  #elif CRY_VAL == USE7_372MHZ
	    (SYSCRL0->RCC)|=(0x0D<<(XTAL));
	  #elif CRY_VAL == USE8MHZ
	    (SYSCRL0->RCC)|=(0x0E<<(XTAL));
	  #elif CRY_VAL == USE8_192MHZ
	    (SYSCRL0->RCC)|=(0x0F<<(XTAL));
	  #elif CRY_VAL == USE10MHZ
	    (SYSCRL0->RCC)|=(0x10<<(XTAL));
	  #elif CRY_VAL == USE12MHZ
	    (SYSCRL0->RCC)|=(0x11<<(XTAL));
	  #elif CRY_VAL == USE12_288MHZ
	    (SYSCRL0->RCC)|=(0x12<<(XTAL));
      #elif CRY_VAL == USE13_56MHZ
	    (SYSCRL0->RCC)|=(0x13<<(XTAL));
      #elif CRY_VAL == USE14_318MHZ
	    (SYSCRL0->RCC)|=(0x14<<(XTAL));
      #elif CRY_VAL == USE16MHZ
	    (SYSCRL0->RCC)|=(0x15<<(XTAL));
      #elif CRY_VAL == USE16_384MHZ
	    (SYSCRL0->RCC)|=(0x16<<(XTAL));
	  #elif CRY_VAL == USE18MHZ
	    (SYSCRL0->RCC)|=(0x17<<(XTAL));		
	  #elif CRY_VAL == USE20MHZ
	    (SYSCRL0->RCC)|=(0x18<<(XTAL));	
      #elif CRY_VAL == USE24MHZ
	    (SYSCRL0->RCC)|=(0x19<<(XTAL));			
      #elif CRY_VAL == USE25MHZ
	    (SYSCRL0->RCC)|=(0x1A<<(XTAL));	
	  #else
		  #error("you chose wrong crystal value")
	  #endif
	 ///////////////////OSC////////////////////////////////
     #if 	OSC_VAL == MOSC
	    (SYSCRL0->RCC)|=(0<<(OSCSRC));
	 #elif  OSC_VAL == PIOSC
      	(SYSCRL0->RCC)|=(1<<(OSCSRC));
	 #elif  OSC_VAL == PIOSC_4
      	(SYSCRL0->RCC)|=(2<<(OSCSRC));
	 #elif  OSC_VAL == LFIOSC
      	(SYSCRL0->RCC)|=(3<<(OSCSRC));	
      #else	
        #error("you chose wrong osc value")	
	 #endif
	#elif  PLL_USEADGE  ==  PLL_NOT_USED
	(SYSCRL0->)&=~(1<<(BYPASS));
	(SYSCRL0->RCC)&=~(1<<(USESYSDIV)); 
	(SYSCRL0->RCC)&=~(1<<(MOSCDIS));
	(SYSCRL0->RIS)|=(1<<(MOSCPUPRIS));
	  #if CRY_VAL == USE4MHZ
	    (SYSCRL0->RCC)|=(6<<(XTAL));
	  #elif   CRY_VAL == USE4_096MHZ
	    (SYSCRL0->RCC)|=(7<<(XTAL));
	  #elif   CRY_VAL == USE4_9152MHZ
	    (SYSCRL0->RCC)|=(8<<(XTAL));
	  #elif   CRY_VAL == USE5MHZUSB
	    (SYSCRL0->RCC)|=(9<<(XTAL));
	  #elif CRY_VAL == USE5_12MHZ
	    (SYSCRL0->RCC)|=(0x0A<<(XTAL));
	  #elif CRY_VAL == USE6MHZ
	    (SYSCRL0->RCC)|=(0x0B<<(XTAL));
	  #elif CRY_VAL == USE6_144MHZ
	    (SYSCRL0->RCC)|=(0x0C<<(XTAL));
	  #elif CRY_VAL == USE7_372MHZ
	    (SYSCRL0->RCC)|=(0x0D<<(XTAL));
	  #elif CRY_VAL == USE8MHZ
	    (SYSCRL0->RCC)|=(0x0E<<(XTAL));
	  #elif CRY_VAL == USE8_192MHZ
	    (SYSCRL0->RCC)|=(0x0F<<(XTAL));
	  #elif CRY_VAL == USE10MHZ
	    (SYSCRL0->RCC)|=(0x10<<(XTAL));
	  #elif CRY_VAL == USE12MHZ
	    (SYSCRL0->RCC)|=(0x11<<(XTAL));
	  #elif CRY_VAL == USE12_288MHZ
	    (SYSCRL0->RCC)|=(0x12<<(XTAL));
      #elif CRY_VAL == USE13_56MHZ
	    (SYSCRL0->RCC)|=(0x13<<(XTAL));
      #elif CRY_VAL == USE14_318MHZ
	    (SYSCRL0->RCC)|=(0x14<<(XTAL));
      #elif CRY_VAL == USE16MHZ
	    (SYSCRL0->RCC)|=(0x15<<(XTAL));
      #elif CRY_VAL == USE16_384MHZ
	    (SYSCRL0->RCC)|=(0x16<<(XTAL));
	  #elif CRY_VAL == USE18MHZ
	    (SYSCRL0->RCC)|=(0x17<<(XTAL));		
	  #elif CRY_VAL == USE20MHZ
	    (SYSCRL0->RCC)|=(0x18<<(XTAL));	
      #elif CRY_VAL == USE24MHZ
	    (SYSCRL0->RCC)|=(0x19<<(XTAL));			
      #elif CRY_VAL == USE25MHZ
	    (SYSCRL0->RCC)|=(0x1A<<(XTAL));	
	  #else
		  #error("you chose wrong crystal value")
	  #endif
      ///////////////////OSC////////////////////////////////
     #if 	OSC_VAL == MOSC
	    (SYSCRL0->RCC)|=(0<<(OSCSRC));
	 #elif  OSC_VAL == PIOSC
      	(SYSCRL0->RCC)|=(1<<(OSCSRC));
	 #elif  OSC_VAL == PIOSC_4
      	(SYSCRL0->RCC)|=(2<<(OSCSRC));
	 #elif  OSC_VAL == LFIOSC
      	(SYSCRL0->RCC)|=(3<<(OSCSRC));	
      #else	
        #error("you chose wrong osc value")
     #endif	
	#else
		#error("you chose wrong PLL TYPE")
	#endif
	(SYSCRL0->RCC)&=~(1<<(PWRDN));
	
	#if    PLL_USEADGE  ==  PLL_USED
	    #if    SYS_DEVIDER == SYSCTL_SYSDIV_1
		   (SYSCRL0->RCC)|=(0<<(SYSDIV));
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_2
		   (SYSCRL0->RCC)|=(1<<(SYSDIV));
		 #elif  SYS_DEVIDER == SYSCTL_SYSDIV_3
		   (SYSCRL0->RCC)|=(2<<(SYSDIV));
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_4
		   (SYSCRL0->RCC)|=(3<<(SYSDIV));  
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_5
		   (SYSCRL0->RCC)|=(4<<(SYSDIV));  
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_6
		   (SYSCRL0->RCC)|=(5<<(SYSDIV));   
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_7
		   (SYSCRL0->RCC)|=(6<<(SYSDIV));  
	    #elif  SYS_DEVIDER == SYSCTL_SYSDIV_8
		   (SYSCRL0->RCC)|=(7<<(SYSDIV)); 
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_9
		   (SYSCRL0->RCC)|=(8<<(SYSDIV));   
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_10
		   (SYSCRL0->RCC)|=(9<<(SYSDIV));   
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_11
		   (SYSCRL0->RCC)|=(10<<(SYSDIV)); 
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_12
		   (SYSCRL0->RCC)|=(11<<(SYSDIV)); 
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_13
		   (SYSCRL0->RCC)|=(12<<(SYSDIV));  
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_14
		   (SYSCRL0->RCC)|=(13<<(SYSDIV)); 
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_15
		   (SYSCRL0->RCC)|=(14<<(SYSDIV));  
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_16
		   (SYSCRL0->RCC)|=(15<<(SYSDIV));     
		#else
			#error("you enter wrong SYS_DEVIDER")
		#endif
	#elif  PLL_USEADGE  ==  PLL_NOT_USED
		   (SYSCRL0->RCC)=0b00000000000000000000000000000000;

	    #if  SYS_DEVIDER == SYSCTL_SYSDIV_3
		   (SYSCRL0->RCC)|=(2<<(SYSDIV));
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_4
		   (SYSCRL0->RCC)|=(3<<(SYSDIV));  
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_5
		   (SYSCRL0->RCC)|=(4<<(SYSDIV));  
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_6
		   (SYSCRL0->RCC)|=(5<<(SYSDIV));   
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_7
		   (SYSCRL0->RCC)|=(6<<(SYSDIV));  
	    #elif  SYS_DEVIDER == SYSCTL_SYSDIV_8
		   (SYSCRL0->RCC)|=(7<<(SYSDIV)); 
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_9
		   (SYSCRL0->RCC)|=(8<<(SYSDIV));   
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_10
		   (SYSCRL0->RCC)|=(9<<(SYSDIV));   
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_11
		   (SYSCRL0->RCC)|=(10<<(SYSDIV)); 
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_12
		   (SYSCRL0->RCC)|=(11<<(SYSDIV)); 
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_13
		   (SYSCRL0->RCC)|=(12<<(SYSDIV));  
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_14
		   (SYSCRL0->RCC)|=(13<<(SYSDIV)); 
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_15
		   (SYSCRL0->RCC)|=(14<<(SYSDIV));  
		#elif  SYS_DEVIDER == SYSCTL_SYSDIV_14
		   (SYSCRL0->RCC)|=(15<<(SYSDIV));     
		#else
			#error("you enter wrong SYS_DEVIDER")
		#endif
	#else
		#error("you chose wrong PLL TYPE")
	#endif
	(SYSCRL0->RCC)|=(1<<(USESYSDIV));
	while(!(GET_BIT(SYSCRL0->RIS,PLLLRIS)));
	(SYSCRL0->RCC)&=~(1<<(BYPASS));
}
  
void  GPIO_PERFORMANCE_BUS(u8 PERF_BUS , u8 GPIO_PORT)
{
	if(PERF_BUS == APB)
	{
		switch(GPIO_PORT)
		{
			case PORTA: CLR_BIT(SYSCRL0->GPIOHBCTL,PORTA); break;
			case PORTB: CLR_BIT(SYSCRL0->GPIOHBCTL,PORTB); break;
			case PORTC: CLR_BIT(SYSCRL0->GPIOHBCTL,PORTC); break;
			case PORTD: CLR_BIT(SYSCRL0->GPIOHBCTL,PORTD); break;
			case PORTF: CLR_BIT(SYSCRL0->GPIOHBCTL,PORTF); break;
			default: /* do no thing*/ 
		}
	}
	else if (PERF_BUS == AHB)
	{
		switch(GPIO_PORT)
		{
			case PORTA: SET_BIT(SYSCRL0->GPIOHBCTL,PORTA); break;
			case PORTB: SET_BIT(SYSCRL0->GPIOHBCTL,PORTB); break;
			case PORTC: SET_BIT(SYSCRL0->GPIOHBCTL,PORTC); break;
			case PORTD: SET_BIT(SYSCRL0->GPIOHBCTL,PORTD); break;
			case PORTF: SET_BIT(SYSCRL0->GPIOHBCTL,PORTF); break;
			default: /* do no thing*/ 
		}
	}
    else
	{
		/*Do No thing*/
	}	
}

 
void ENABLE_GPIO_CLOCK( u8 GPIO_PORT ) 
{
	//SET_BIT(SYSCRL0->RCGCGPIO,GPIO_PORT);
	//SET_BIT(SYS_RCGCTIMER,GPIO_PORT);
   // SYSCRL0->RCGCGPIO |= (1<<GPIO_PORT);SYS_RCGCGPIO
    SYS_RCGCGPIO |=(1<<GPIO_PORT);
} 

void ENABLE_GPIO_CLOCK_SLEEP_MODE( u8 GPIO_PORT ) 
{
	SET_BIT(SYSCRL0->SCGCGPIO,GPIO_PORT);
} 

void ENABLE_GPIO_CLOCK_DEEP_SLEEP_MODE( u8 GPIO_PORT ) 
{
	SET_BIT(SYSCRL0->DCGCGPIO,GPIO_PORT);
} 




