/*
* TRAGET MCU NAME: TM4C123GH6PM
* 16/5/2021
* SysTick    PAGE 123
* Versoin : 0
*
*
*/
#include"types.h"
#include"bitwise.h"
#include"SYSTIC_pravite.h"
#include"SYSTIC_config.h"
#include"SYSTIC_interface.h"


u8 INTERVAL_MODE ;
u8 SINGLE_MODE = 0;
u8 PERODIC_MODE = 1;

void (*CALLBACK) (void);

void SYSTIC_INIT(u8 CLK_TYPE , u8 INT_ENABLE)
{
	STCTRL |= (CLK_TYPE<<CLK_SRC)|(INT_ENABLE<<INTEN);
}

void BUSY_WAIT(u32 SYSTIC_TICKS)
{
    STCTRL &=~ (1<<INTEN);
	STRELOAD = SYSTIC_TICKS;
	STCTRL |= (1<<ENABLE);
	while(GET_BIT(STCTRL,COUNT)==0);
}

void SYSTICK_SINGLE_INTERVAL(u32 SYSTIC_TICKS , void (*FUN_PTR)(void) )
{
        STCTRL &=~ (1<<ENABLE);
        STCURRENT= 0;
        STRELOAD = SYSTIC_TICKS;
        STCTRL |= (1<<ENABLE);
        CALLBACK = FUN_PTR ;
        INTERVAL_MODE = SINGLE_MODE;
        STCTRL |= (1<<INTEN);
}


void SYSTICK_PERODIC_INTERVAL(u32 SYSTIC_TICKS , void (*FUN_PTR)(void) )
{
        STCTRL &=~ (1<<ENABLE);
        STCURRENT= 0;
        STRELOAD = SYSTIC_TICKS;
        STCTRL |= (1<<INTEN)|(1<<ENABLE);
       // STCTRL |= (1<<ENABLE);
        CALLBACK = FUN_PTR ;
        INTERVAL_MODE = PERODIC_MODE;

}

void SysTickIntHandler(void)
{
    u8 Local_u8Temporary = 0;
    if(INTERVAL_MODE == SINGLE_MODE)
    {
        STCTRL &~ (1<<INTEN);
        STCTRL &~ (1<<ENABLE);
        STRELOAD = 0 ;
        STCURRENT= 0;
    }
    CALLBACK();
    Local_u8Temporary = GET_BIT(STCTRL,COUNT);
}



void STOP_SYSTIC(void)
{
    STCTRL &~ (1<<ENABLE);
}


u32 RETURN_CURRENT_SYSTIC_VALUE(void)
{
    u32 CURRENT ;
    CURRENT = STCURRENT;
    return  CURRENT ;
}

u32 RETURN_REMAIN_SYSTIC_VALUE(void)
{
    u32 ELABSE = 0;
    ELABSE = STRELOAD - STCURRENT ;
    return  ELABSE ;
}


