
#include <stdint.h>
#include <stdbool.h>
#include <stdio.h>

#include "driverlib/fpu.h"
#include "driverlib/sysctl.h"
#include "driverlib/interrupt.h"

#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/pushbutton.h"
#include "grlib/canvas.h"

#include "touch.h"
#include "kitronix320x240x16_ssd2119_spi.h"





// Declaration of the buttons' OnClick handler
//
void OnButtonClick( tWidget *psWidget );

// Handles messages from the touch screen driver
//
int32_t TSHandler( uint32_t ui32Message, int32_t i32X, int32_t i32Y );





// Display specific stuff for the Kentec LCD
//
extern const tDisplay g_sKentec320x240x16_SSD2119;


// Actual clock speed
//
uint32_t 		g_ui32SysClock = 0;









//
// Declare two canvasses, each will hold one button
//

Canvas( g_MenuCanvas_1,
		0, 0, 0,
		&g_sKentec320x240x16_SSD2119,
		0, 0,
		LCD_HORIZONTAL_MAX, LCD_VERTICAL_MAX,
		CANVAS_STYLE_FILL | CANVAS_STYLE_TEXT | CANVAS_STYLE_TEXT_TOP | CANVAS_STYLE_TEXT_HCENTER,
		ClrBlack, ClrWhite, ClrWhite,
		&g_sFontCmsc20, "This Is Canvas 1",
		NULL,
		NULL );

Canvas( g_MenuCanvas_2,
		0, 0, 0,
		&g_sKentec320x240x16_SSD2119,
		0, 0,
		LCD_HORIZONTAL_MAX, LCD_VERTICAL_MAX,
		CANVAS_STYLE_FILL | CANVAS_STYLE_TEXT | CANVAS_STYLE_TEXT_TOP | CANVAS_STYLE_TEXT_HCENTER,
		ClrBlack, ClrWhite, ClrWhite,
		&g_sFontCmsc20, "This Is Canvas 2",
		NULL,
		NULL );


//
// Declare two buttons - one for each canvas.
//

RectangularButton( g_btnToggle_1_To_2,
		0, 0, 0,
		&g_sKentec320x240x16_SSD2119,
		LCD_HORIZONTAL_MAX/5, LCD_VERTICAL_MAX/2,
		LCD_HORIZONTAL_MAX*3/5, 27,
		PB_STYLE_FILL | PB_STYLE_OUTLINE | PB_STYLE_TEXT,
		ClrLightSteelBlue, ClrDarkBlue, ClrWhite, ClrWhite,
		&g_sFontCmsc18, "Switch To canvas 2", NULL, NULL,
		0, 0,
		OnButtonClick );


RectangularButton( g_btnToggle_2_To_1,
		0, 0, 0,
		&g_sKentec320x240x16_SSD2119,
		LCD_HORIZONTAL_MAX/5, LCD_VERTICAL_MAX/2,
		LCD_HORIZONTAL_MAX*3/5, 27,
		PB_STYLE_FILL | PB_STYLE_OUTLINE | PB_STYLE_TEXT,
		ClrLightSteelBlue, ClrDarkBlue, ClrWhite, ClrWhite,
		&g_sFontCmsc18, "Switch To canvas 1", NULL, NULL,
		0, 0,
		OnButtonClick );















int main(void)
{
	// First things first, set the system clock to run from the PLL @ 120 MHz.
	//
	g_ui32SysClock = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ |
										 SYSCTL_OSC_MAIN   |
										 SYSCTL_USE_PLL    |
										 SYSCTL_CFG_VCO_480), 120000000);

	// FPU on with lazy stacking
	FPUEnable();
	FPULazyStackingEnable();


    // Initialize the LCD & Touchscreen
	Kentec320x240x16_SSD2119Init();
	TouchScreenInit( g_ui32SysClock );
	TouchScreenCallbackSet( TSHandler );

	// Hardware initialised, can now enable interrupts at the CPU for the ADC touch conversions
    IntMasterEnable();



	/********************************************
	 *                                          *
	 *  That's the hardware setup finished,     *
	 *  Now prepare our canvas widgets.         *
	 *                                          *
	 ********************************************/

    // Add a button to each of the canvasses
	WidgetAdd( (tWidget*) &g_MenuCanvas_1, (tWidget*) &g_btnToggle_1_To_2 );
	WidgetAdd( (tWidget*) &g_MenuCanvas_2, (tWidget*) &g_btnToggle_2_To_1 );

	// The canvasses are ready. Show canvas 1 initially.
	WidgetAdd( WIDGET_ROOT, (tWidget*) &g_MenuCanvas_1 );
	WidgetPaint( WIDGET_ROOT );



    /********************************************
     *                                          *
     *  Ready for blastoff. Let the message     *
     *  loop do all the work.                   *
     *                                          *
     ********************************************/

	while(1)
	{
		WidgetMessageQueueProcess();
	}

}








// OnClick handler for the buttons
//
void
OnButtonClick( tWidget *psWidget )
{
	if (psWidget == (tWidget*) &g_btnToggle_1_To_2)
	{
		// Remove canvas 1 from WIDGET_ROOT and add canvas 2
		WidgetRemove( (tWidget*) &g_MenuCanvas_1 );
		WidgetAdd( WIDGET_ROOT, (tWidget*) &g_MenuCanvas_2 );
	}
	else if (psWidget == (tWidget*) &g_btnToggle_2_To_1 )
	{
		// Remove canvas 2 from WIDGET_ROOT and go back to canvas 1
		WidgetRemove( (tWidget*) &g_MenuCanvas_2 );
		WidgetAdd( WIDGET_ROOT, (tWidget*) &g_MenuCanvas_1 );
	}
	else
	{
		// Unknown widget! Just spin.
		for(;;);
	}

	WidgetPaint( WIDGET_ROOT );
}









// Messages from the actual touch screen driver arrive here. Just pass them on to the default handler
//
int32_t
TSHandler( uint32_t ui32Message, int32_t i32X, int32_t i32Y )
{
    WidgetPointerMessage( ui32Message, i32X, i32Y );

    // Tell the touch handler everything is fine.
    return 1;
}

