/*
 * Network.h
 *
 *  Created on: 10 Jun 2023
 *      Author: chris
 */
#pragma once

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "FreeRTOS.h"
#include "task.h"

/* lwIP core includes */
#include "lwip/opt.h"
#include "lwip/sys.h"
#include "lwip/tcpip.h"
#include "lwip/dhcp.h"

#include <kernel/dpl/TaskP.h>
#include <kernel/dpl/ClockP.h>

#include <networking/enet/utils/include/enet_apputils.h>
#include <networking/enet/utils/include/enet_board.h>

#include "ti_board_config.h"
#include "ti_board_open_close.h"
#include "ti_drivers_open_close.h"
#include "ti_enet_config.h"
#include "ti_enet_open_close.h"
#include "ti_enet_lwipif.h"

class Network
{

public:
    Network() = default;
    virtual ~Network() = default;

    int init()
    {
        Enet_Type enetType;
        uint32_t instId;

        Drivers_open();
        Board_driversOpen();

        EnetApp_getEnetInstInfo(&enetType, &instId);
        EnetAppUtils_enableClocks(enetType, instId);

        const int32_t status = EnetApp_driverOpen(enetType, instId);

        return 1;
    }
};

