#include "ti_msp_dl_config.h"

#define MAIN_CLOCK                          ((uint32_t)32000000)

void delayMs(uint16_t mSec)
{
    delay_cycles((MAIN_CLOCK / 1000) * mSec);
}

int main(void)
{
    volatile DL_SYSCTL_RESET_CAUSE rstCause;

    SYSCFG_DL_init();

    rstCause = DL_SYSCTL_getResetCause();
	if (DL_SYSCTL_RESET_CAUSE_BOR_WAKE_FROM_SHUTDOWN == rstCause)
    {
        /* Release IO after Shutdown before initializing any peripherals */
        DL_SYSCTL_releaseShutdownIO();
        // Need delay before read pin value
        delay_cycles(10);

        if (DL_GPIO_readPins(GPIO_PRESSURE_SWITCH_PORT, GPIO_PRESSURE_SWITCH_PRESSURE_SWITCH_PIN))
        {
            DL_GPIO_togglePins(User_Led_PORT, User_Led_PIN_R_LED_PIN);
            delayMs(1000);
            DL_GPIO_togglePins(User_Led_PORT, User_Led_PIN_R_LED_PIN);
            delayMs(1000);
            DL_GPIO_togglePins(User_Led_PORT, User_Led_PIN_R_LED_PIN);
            delayMs(1000);
        }
        else if (DL_GPIO_readPins(GPIO_CURRENT_OVERLOAD_PORT, GPIO_CURRENT_OVERLOAD_CURRENT_OVERLOAD_PIN))
        {
            DL_GPIO_togglePins(User_Led_PORT, User_Led_PIN_G_LED_PIN);
            delayMs(1000);
            DL_GPIO_togglePins(User_Led_PORT, User_Led_PIN_G_LED_PIN);
            delayMs(1000);
            DL_GPIO_togglePins(User_Led_PORT, User_Led_PIN_G_LED_PIN);
            delayMs(1000);
        }
    }
    else
    {
        DL_GPIO_togglePins(User_Led_PORT, User_Led_PIN_B_LED_PIN);
        delayMs(1000);
    }

   /*
    * Configure Shutdown wake-up pin to wake-up when pin is set
    * to high before changing power policy to SHUTDOWN
    */
    DL_GPIO_initDigitalInputFeatures(GPIO_PRESSURE_SWITCH_PRESSURE_SWITCH_IOMUX,
                                     DL_GPIO_INVERSION_DISABLE, DL_GPIO_RESISTOR_NONE,
                                     DL_GPIO_HYSTERESIS_DISABLE, DL_GPIO_WAKEUP_ON_1);
    
    DL_GPIO_initDigitalInputFeatures(GPIO_CURRENT_OVERLOAD_CURRENT_OVERLOAD_IOMUX,
                                     DL_GPIO_INVERSION_DISABLE, DL_GPIO_RESISTOR_NONE,
                                     DL_GPIO_HYSTERESIS_DISABLE, DL_GPIO_WAKEUP_ON_1);

    DL_SYSCTL_setPowerPolicySHUTDOWN();

    //Toggle BLUE led to confirm wakeup and shutdown status
    DL_GPIO_togglePins(User_Led_PORT, User_Led_PIN_B_LED_PIN);
    delayMs(1000);
    DL_GPIO_togglePins(User_Led_PORT, User_Led_PIN_B_LED_PIN);

    while (1)
    {
        __WFI(); /* Enter selected power policy */
    }

}

