/** @file sys_main.c
 *   @brief Application main file
 *   @date 11-Dec-2018
 *   @version 04.07.01
 *
 *   This file contains an empty main function,
 *   which can be used for the application.
 */

/*
 * Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"
#include "system.h"

#include <sci.h>

#include <emac.h>

/* USER CODE BEGIN (1) */
/* USER CODE END */

/** @fn void main(void)
 *   @brief Application main function
 *   @note This function is empty by default.
 *
 *   This function is called after startup.
 *   The user can use this function to implement the application.
 */

/* USER CODE BEGIN (2) */

#define UART scilinREG
extern hdkif_t hdkif_data[1];


/* USER CODE END */

uint8	emacAddress[6U] = 	{0x11U, 0x22U, 0x33U, 0x44U, 0x55U, 0x1U};
uint32 	emacPhyAddress	=	1U;

int main(void)
{
    /* USER CODE BEGIN (3) */

    _enable_IRQ();
    EMACHWInit(emacAddress);
    sciInit();      /* initialize sci/sci-lin    */

    hdkif_t *hdkif;
    hdkif = &hdkif_data[0U];
    EMACInstConfig(hdkif);
    uint32 retVal = EMAC_ERR_OK;
    volatile uint32 phyLinkRetries = 0xFFFFU;
    volatile uint32 phyID=0U;
    hdkif = &hdkif_data[0U];
    EMACInstConfig(hdkif);

    while(1)
    {
        if(!Dp83640LinkStatusGet(hdkif->mdio_base, (uint32)EMAC_PHYADDRESS, (uint32)0xFFFFU)) {
            retVal = EMAC_ERR_CONNECT;

            sciDisplayText(UART,"Linkup Fail\n\r",sizeof("Linkup Fail\n\r"));   /* send text code 1 */

        }
        else
        {
            sciDisplayText(UART,"Linkup success\n\r",sizeof("Linkup success\n\r"));   /* send text code 1 */


        }

    }


    /* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */

void sciDisplayText(sciBASE_t *sci, uint8 *text,uint32 length)
{
    while(length--)
    {
        while ((UART->FLR & 0x4) == 4); /* wait until busy */
        sciSendByte(UART,*text++);      /* send out text   */
    };
}

/* USER CODE END */
