/*-------------------------------------------*/
/* Integer type definitions for FatFs module */
/*-------------------------------------------*/

#ifndef _INTEGER
#define _INTEGER

#ifdef _WIN32	/* FatFs development platform */

#include <windows.h>
#include <tchar.h>

#else			/* Embedded platform */

/* These types must be 16-bit, 32-bit or larger integer */
typedef int				FS_INT;
typedef unsigned int	FS_UINT;

/* These types must be 8-bit integer */
typedef char			FS_CHAR;
typedef unsigned char	FS_UCHAR;
typedef unsigned char	FS_BYTE;

/* These types must be 16-bit integer */
typedef short			FS_SHORT;
typedef unsigned short	FS_USHORT;
typedef unsigned short	FS_WORD;
typedef unsigned short	FS_WCHAR;

/* These types must be 32-bit integer */
typedef long			FS_LONG;
typedef unsigned long	FS_ULONG;
typedef unsigned long	FS_DWORD;

/* Boolean type */
typedef enum { FS_FALSE = 0, FS_TRUE } FS_BOOL;

#endif

#endif
