///////////////////////////////////////////////////////////////////////////
// {
//
// 2015/02/19
///////////////////////////////////////////////////////////////////////////
#ifndef __U_GEN_H__
//[[[
#define __U_GEN_H__

#undef EXTERN
#ifndef MONITOR_DEF_GEN
#define EXTERN extern
#else
#define EXTERN
#endif

typedef uint8_t								BYTE;
typedef uint16_t							WORD;
typedef uint32_t							DWORD;
typedef uint64_t							QWORD;

#define HIDWORD(qw)						((DWORD)((qw)>>(32)))
#define LODWORD(qw)						((DWORD)(qw))
#define HIWORD(dw)						((WORD)((dw)>>(16)))
#define LOWORD(dw)						((WORD)(dw))
#define HIBYTE(w)							((BYTE)((w)>>(8)))
#define LOBYTE(w)							((BYTE)(w))

#define MAKEWORD(h,l)					((WORD)(((WORD)(h) << 8) | (WORD)(l)))
#define MAKEDWORD(h,l)				((DWORD)(((DWORD)(h) << 16) | (DWORD)(l)))
#define MAKEQWORD(h,l)				((QWORD)(((QWORD)(h) << 32) | (QWORD)(l)))

#define BIT(x)								((1) << (x))
#define BITL(x)								((1L) << (x))

extern	const BYTE	cbarrHEX[];

WORD	XorShift16(WORD wSeed);						// [

BYTE atoh(BYTE b);												// 16i𐔎ɕϊ
BYTE atod(BYTE b);												// 10i𐔎ɕϊ
BYTE strtob(BYTE* pabSrc);								// 16i21oCgɕϊ
WORD strtow(BYTE* pabSrc);								// 16i41[hɕϊ
BYTE dstrtob(BYTE* pabSrc);								// 10i21oCgɕϊ


// G[R[h`
//                         AAAABBBBCCCCDDDD
#define		RTC_ERR				(0x0000000000000001)
#define		RTC_I2CERR		(0x0000000000000002)
#define		RTC_I2CBUSY		(0x0000000000000004)
#define		RTC_ERRMASK		(0x000000000000000F)

#define		POW_2VERR			(0x0000000000000010)
#define		POW_COREERR		(POW_2VERR)
#define		POW_5V1ERR		(0x0000000000000020)
#define		POW_CAN0ERR		(POW_5V1ERR)
#define		POW_5V2ERR		(0x0000000000000040)
#define		POW_CAN1ERR		(POW_5V2ERR)
#define		POW_12VERR		(0x0000000000000080)
#define		POW_IGUIERR		(POW_12VERR)
#define		POW_ERRMASK		(0x00000000000000F0)

#define		UART_PUTERR		(0x0000000000100000)
#define		UART_GETERR		(0x0000000000200000)
#define		UART_GETERFRM	(0x0000000000210000)	// t[~OG[
#define		UART_GETERPRY	(0x0000000000220000)	// peBG[
#define		UART_GETERBRK	(0x0000000000240000)	// u[NG[
#define		UART_GETEROVR	(0x0000000000280000)	// I[o[G[
#define		UART_ERRMASK	(0x00000000003F0000)
#define		UART_GETERMSK	(0x00000000002F0000)

#define		CAM_AKI2CERR	(0x0000000000001000)
#define		CAM_AKI2CBUSY	(0x0000000000002000)
#define		CAM_S2I2CERR	(0x0000000000004000)
#define		CAM_S2I2CBUSY	(0x0000000000008000)
#define		CAM_ERRMASK		(0x000000000000F000)

#define		EXADC_ERR			(0x1000000000000000)

#define		ERR_ALL				(0xFFFFFFFFFFFFFFFF)

extern	bool	ErrorFlagCheck(QWORD qwErr);		// G[Ԃ̊mF true ŃG[
extern	void	ErrorFlagSet(QWORD qwErr);			// G[Ԃ̃Zbg
extern	void	ErrorFlagClr(QWORD qwErr);			// G[Ԃ̃NA

#endif
//]]]
