///////////////////////////////////////////////////////////////////////////
// SDRAM(EPI0) 8MB SDRAM(MT48LC4M16A2B4-6AIT:J)
//
// 2015/11/16
///////////////////////////////////////////////////////////////////////////
#define	MONITOR_DEF_SDRAM
#include "Monitorbase.h"

static	volatile	WORD	*gwarrSDRAM;				// externsƓ{

// The Mapping address space for the EPI SDRAM.
//#define	SDRAM_MAPPING_ADDRESS				(0x60000000)

// A pointer to the EPI memory aperture.  Note that g_pui16EPISdram is declared
// as volatile so the compiler should not optimize reads out of the image.
//static	volatile	WORD	*gwarrSDRAM;			// ̌`łexternsȂ

// A table used to determine the EPI clock frequency band in use.
typedef struct {
	uint32_t ui32SysClock;
	uint32_t ui32FreqFlag;
} tSDRAMFreqMapping;

static tSDRAMFreqMapping g_psSDRAMFreq[] = {
	// SysClock >= 100MHz, EPI clock >= 50Mhz (divided by 2)
	{100000000, EPI_SDRAM_CORE_FREQ_50_100},
	// SysClock >= 60MHz, EPI clock >= 30MHz (divided by 2)
	{60000000, EPI_SDRAM_CORE_FREQ_50_100},
	// SysClock >= 50MHz, EPI clock >= 50MHz (no divider)
	{50000000, EPI_SDRAM_CORE_FREQ_50_100},
	// SysClock >= 30MHz, EPI clock >= 30MHz (no divider)
	{50000000, EPI_SDRAM_CORE_FREQ_30_50},
	// SysClock >= 15MHz, EPI clock >= 15MHz (no divider)
	{15000000, EPI_SDRAM_CORE_FREQ_15_30},
	// SysClock < 15Mhz, EPI clock < 15Mhz (no divider)
	{0, EPI_SDRAM_CORE_FREQ_0_15}
};

#define	NUM_SDRAM_FREQ	(sizeof(g_psSDRAMFreq) / sizeof(tSDRAMFreqMapping))


// SDRAM̍őTCY 0x003FFFFF ܂Ŏgp\

// ʗpobt@TCY
// 32bit col
// 4bytes * 800 * 480 = 1536000
// 1536000 = 0x00177000
// OtBbNpobt@[A		0x00000000 ` 0x00176FFF ܂
// OtBbNpobt@[B		0x00177000 ` 0x002EDFFF ܂
// c 0x00400000 - 0x002EE000 = 0x00112000 = 2MBx

// FatFspobt@[TCY 256KB = 128Kwords = 0x20000 * 2 = 0x40000
// Flash @FatFspobt@[			0x002EE000 ` 0x0032DFFF ܂
// c 0x00400000 - 0x0032E000 = 0x000D2000 = 1.6MBx

// RAMfBXNTCY 1.5MB = 0.75Mwords = 0x000C0000
// OtBbNpRAMfBXN		0x0032E000 ` 0x003EDFFF ܂
// c 0x00400000 - 0x003EE000 = 0x00012000 = 0.14MBx
#define	SDRAM_GBUF_SIZE							(0x00177000)
#define	SDRAM_GBUF_WSIZE						(0x002EE000)
#define	SDRAM_RAMDISK_SIZE					(0x000C0000)
#define	SDRAM_FATBUF_SIZE						(0x00040000)

#define	SDRAM_GBUF_A_STARTADD				(0x00000000)																				// 摜obt@[A 擪AhX
#define	SDRAM_GBUF_A_ENDADD					(SDRAM_GBUF_SIZE - 1)																// 摜obt@[A ŏIAhX
#define	SDRAM_GBUF_B_STARTADD				(SDRAM_GBUF_SIZE)																		// 摜obt@[B 擪AhX
#define	SDRAM_GBUF_B_ENDADD					(SDRAM_GBUF_WSIZE - 1)															// 摜obt@[B ŏIAhX
#define	SDRAM_RAMDISK_STARTADD			(SDRAM_GBUF_WSIZE)																	// RAMfBXN 擪AhX
#define	SDRAM_RAMDISK_ENDADD				(SDRAM_RAMDISK_STARTADD + SDRAM_RAMDISK_SIZE - 1)		// RAMfBXN ŏIAhX
#define	SDRAM_FATBUF_STARTADD				(SDRAM_RAMDISK_ENDADD + 1)													// FATpobt@[ 擪AhX
#define	SDRAM_FATBUF_ENDADD					(SDRAM_FATBUF_STARTADD + SDRAM_FATBUF_SIZE -1)			// FATpobt@[ ŏIAhX

//////////////////////////////////////////////////////////// [[[
// SDRAM֐
//	
//		NbNݒ肵ۂ̖߂l
//	߂l
//		true / false
bool	SDramInit(uint32_t dwSysClock){
	DWORD	ui32Val;
	DWORD	ui32Freq;

	// Is our current system clock faster than we can drive the SDRAM clock?
	/*
	if(dwSysClock > 60000000){
		// Yes. Set the EPI clock to half the system clock.
		// s
		ROM_EPIDividerSet(EPI0_BASE, 1);
	} else {
		// With a system clock of 60MHz or lower, we can drive the SDRAM at
		// the same rate so set the divider to 0.
		ROM_EPIDividerSet(EPI0_BASE, 0);
	}
	*/
	ROM_EPIDividerSet(EPI0_BASE, 1);

	// Sets the usage mode of the EPI module.  For this example we will use
	// the SDRAM mode to talk to the external 64MB SDRAM daughter card.
	ROM_EPIModeSet(EPI0_BASE, EPI_MODE_SDRAM);

	// Keep the compiler happy by setting a default value for the frequency flag.
	ui32Freq = g_psSDRAMFreq[NUM_SDRAM_FREQ - 1].ui32FreqFlag;

	// Examine the system clock frequency to determine how to set the SDRAM controller's frequency flag.
	for(ui32Val = 0; ui32Val < NUM_SDRAM_FREQ; ui32Val++){
		// Is the system clock frequency above the break point in the table?
		if(dwSysClock >= g_psSDRAMFreq[ui32Val].ui32SysClock){
			// Yes - remember the frequency flag to use and exit the loop.
			ui32Freq = g_psSDRAMFreq[ui32Val].ui32FreqFlag;
			break;
		}
	}
	
	// Configure the SDRAM mode.  We configure the SDRAM according to our core
	// clock frequency.  We will use the normal (or full power) operating
	// state which means we will not use the low power self-refresh state.
	// Set the SDRAM size to 64MB with a refresh interval of 1024 clock ticks.
	// SDRAM[hݒ肵܂B
	// RAENbNgɉSDRAMݒ肵܂B
	// X́Ad͂̃ZttbVԂgpȂƂӖAʏ́i܂̓tp[jԂgp܂B
	// NbNeBbN1024̃tbVԊu64KoCg܂łSDRAMTCYݒ肵܂B
	ROM_EPIConfigSDRAMSet(EPI0_BASE, (ui32Freq | EPI_SDRAM_FULL_POWER | EPI_SDRAM_SIZE_64MBIT), 1024);

	// Set the address map.  The EPI0 is mapped from 0x60000000 to 0x01FFFFFF.
	// For this example, we will start from a base address of 0x60000000 with
	// a size of 256MB.  Although our SDRAM is only 64MB, there is no 64MB
	// aperture option so we pick the next larger size.
	// AhX}bvݒ肵܂B
	// EPI00x600000000x01FFFFFFɃ}bsO܂B
	// ̗ł́A256KoCg̃TCY0x60000000̃x[XAhXJn܂B
	// SDRAM͗B64KoCgłAX͎ɑ傫TCYIԂ悤ɁA64KoCg̊JIvV͂܂B
	ROM_EPIAddressMapSet(EPI0_BASE, EPI_ADDR_RAM_SIZE_16MB | EPI_ADDR_RAM_BASE_6);

	// Wait for the SDRAM wake-up to complete by polling the SDRAM
	// initialization sequence bit.  This bit is true when the SDRAM interface
	// is going through the initialization and false when the SDRAM interface
	// it is not in a wake-up period.
	while(HWREG(EPI0_BASE + EPI_O_STAT) &  EPI_STAT_INITSEQ){
		// SDRAMN҂
	}

	// Set the EPI memory pointer to the base of EPI memory space.  Note that
	// g_pui16EPISdram is declared as volatile so the compiler should not
	// optimize reads out of the memory.  With this pointer, the memory space
	// is accessed like a simple array.
	// EPIԂ̃x[XEPĨ|C^ݒ肵܂B
	// g_pui16EPISdramvolatileƂĐ錾Ă̂ŁAœKׂł͂܂RpĆA̓ǂݏos܂B
	// ̃|C^ɂAԂ́APȔẑ悤ɃANZX܂B
	gwarrSDRAM = (WORD *)SDRAM_MAPPING_ADDRESS;

	return true;
}

//////////////////////////////////////////////////////////// [[[
// SDRAM̃AhX擾
//	
//		iV
//	߂l
//		SDRAM̐擪AhX
WORD*	GetSDRAMBaseAddress(void){
	return	(WORD*)&gwarrSDRAM[0];
}

//////////////////////////////////////////////////////////// [[[
// SDRAM̃AhX擾(LCDpobt@[)
//	
//		iV
//	߂l
//		SDRAM̃AhX
WORD*	GetSDRAMLCDBufAddressA(void){
	return	(WORD*)&gwarrSDRAM[SDRAM_GBUF_A_STARTADD];
}
WORD*	GetSDRAMLCDBufAddressB(void){
	return	(WORD*)&gwarrSDRAM[SDRAM_GBUF_B_STARTADD];
}

//////////////////////////////////////////////////////////// [[[
// SDRAM̃AhX擾(Fatpobt@[)
//	
//		iV
//	߂l
//		SDRAM̃AhX
WORD*	GetSDRAMFatBufAddress(void){
	return	(WORD*)&gwarrSDRAM[SDRAM_FATBUF_STARTADD];
}

//////////////////////////////////////////////////////////// [[[
// Fatpobt@[̃NA
//	
//		iV
//	߂l
//		true / false
bool	SDRAM_FatBufClr(void){
	DWORD	dw;
	for(dw=0;dw<SDRAM_FATBUF_SIZE;dw++){
		gwarrSDRAM[SDRAM_FATBUF_STARTADD + dw] = 0x0000;				// [hTCỸobt@[̃NA
	}
	return true;
}

//////////////////////////////////////////////////////////// [[[
// Fatpobt@[ւ̊i[
//	
//		BYTE* ۑ256koCgf[^ւ̃|C^[
//	߂l
//		true / false
bool	SDRAM_FatBufSave(BYTE* pbDat){
	DWORD	dw;
	WORD	w;
	for(dw=0;dw<SDRAM_FATBUF_SIZE;dw++){
		w = MAKEWORD( *(pbDat + 2*dw) , *(pbDat + 2*dw +1) );
		gwarrSDRAM[SDRAM_FATBUF_STARTADD + dw] = w;							// [hTCỸobt@[̕ۑ
	}
	return true;
}

//////////////////////////////////////////////////////////// [[[
// Fatpobt@[ւ̊i[iwAhXj
//	
//		WORD JnʒuioCgjAWORD iBYTEjABYTE* ۑf[^ւ̃|C^[
//	߂l
//		true / false
bool	SDRAM_FatBufByteSave(WORD wStart, WORD wLength, BYTE* pbDat){
	DWORD	dw;
	WORD	w;
	WORD	wStartTmp;
	DWORD	dwEnd;
	bool	bEnd1ByteFlag = false;
	if(wStart + wLength > (SDRAM_FATBUF_SIZE << 1)){	return false;	}		// TCY
	
	if((wStart & 0x0001) == 0x0001){
		// Jnʒu̏ꍇ
		w = gwarrSDRAM[SDRAM_FATBUF_STARTADD + (wStart >> 1)];
		w = MAKEWORD(HIBYTE(w) , *pbDat);
		gwarrSDRAM[SDRAM_FATBUF_STARTADD + (wStart >> 1)] = w;
		if((wLength & 0x0001) == 0x0001){
			// Iʒu̏ꍇAJn̂ŋƂȂ
			dwEnd = (wLength - 1) >> 1;
			wStartTmp = 1;
		} else {
			// IʒȕꍇAJn̂ŊƂȂ
			dwEnd = (wLength >> 1) - 1;				// Ƃ1oCg̏ʂɍs߁A1[hZȂ
			wStartTmp = 0;
		}
		if((wLength & 0x0001) == 0x0000){
			// IʒȕꍇAJn߁AŌ1oCgKv
			bEnd1ByteFlag = true;
		}
	} else {
		// Jnʒȕꍇ
		wStartTmp = 0;
		if((wLength & 0x0001) == 0x0001){
			// Iʒu̏ꍇAƂ1oCgʂɍsKv
			dwEnd = (wLength >> 1) - 1;
		} else {
			// IʒȕꍇAɖȂ
			dwEnd = wLength >> 1;
		}
		if((wLength & 0x0001) == 0x0001){
			// Iʒu̏ꍇAŌ1oCgKv
			bEnd1ByteFlag = true;
		}
	}

	// f[^̏
	for(dw=0;dw<dwEnd;dw++){
		w = MAKEWORD( *(pbDat + wStartTmp), *(pbDat + wStartTmp +1) );
		gwarrSDRAM[SDRAM_FATBUF_STARTADD + dw] = w;
		wStartTmp += 2;
	}
	if(bEnd1ByteFlag == true){
		// truȅꍇAŌ1oCgKv
		w = gwarrSDRAM[SDRAM_FATBUF_STARTADD + dw];
		w = MAKEWORD(HIBYTE(w) , *(pbDat + wLength -1));
		gwarrSDRAM[SDRAM_FATBUF_STARTADD + dw] = w;
	}
	return true;
}

//////////////////////////////////////////////////////////// [[[
// Fatpobt@[̎o
//	
//		BYTE* 󂯓np4koCgf[^ւ̃|C^[
//	߂l
//		true / false
bool	SDRAM_FatBufLoad(BYTE* pbDat){
	DWORD	dw;
	WORD	w;
	for(dw=0;dw<SDRAM_FATBUF_SIZE;dw++){
		w = gwarrSDRAM[SDRAM_FATBUF_STARTADD + dw];
		*(pbDat + 2*dw) = HIBYTE(w);
		*(pbDat + 2*dw +1) = LOBYTE(w);
	}
	return true;
}


