///////////////////////////////////////////////////////////////////////////
// Timer
//
// 2015/11/18
///////////////////////////////////////////////////////////////////////////
#define	MONITOR_DEF_TIMER
#include "Monitorbase.h"

DWORD gdw1usecCounter = 0;
DWORD gdw10usecCounter = 0;
DWORD gdw100usecCounter = 0;

DWORD gdw1msecCounter = 0;
DWORD gdw10msecCounter = 0;
DWORD gdw100msecCounter = 0;
DWORD gdw1000msecCounter = 0;
#define		MSECMASK		((DWORD)0x0FFFFFFF)

extern	void	disk_timerproc(void);								// for FatFs Called in period of 10ms

///////////////////////////////////////////////////////////////////////////
// Timer
///////////////////////////////////////////////////////////////////////////
void	TimerXInit(DWORD dwSysClock){
	// gp
	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER0);
	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER1);
	// ^C}[ ^C}[
	ROM_TimerConfigure(TIMER0_BASE,TIMER_CFG_PERIODIC);
	ROM_TimerConfigure(TIMER1_BASE,TIMER_CFG_PERIODIC);
	// ̃Zbg SysCtlClockGet() = 1sec : 1msec = Clock / 1000
	ROM_TimerLoadSet(TIMER0_BASE, TIMER_A, (uint32_t)(dwSysClock / 1000));
	// ̃Zbg SysCtlClockGet() = 1sec : 1sec = Clock / 1000000
	ROM_TimerLoadSet(TIMER1_BASE, TIMER_A, (uint32_t)(dwSysClock / 1000000));
	// 荞݂̋
	ROM_IntEnable(INT_TIMER0A);
	ROM_IntEnable(INT_TIMER1A);
	ROM_TimerIntEnable(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
	ROM_TimerIntEnable(TIMER1_BASE, TIMER_TIMA_TIMEOUT);
	// ^C}[̗L
	ROM_TimerEnable(TIMER0_BASE,TIMER_A);
	ROM_TimerEnable(TIMER1_BASE,TIMER_A);
	return;
}

///////////////////////////////////////////////////////////////////////////
// Timer0̊荞݊֐ 1msec
///////////////////////////////////////////////////////////////////////////
void	Timer0IntHandler(void){
	//
	// Clear the timer interrupt.
	//
	ROM_TimerIntClear(TIMER0_BASE, TIMER_TIMA_TIMEOUT);

	gdw1msecCounter++;
	gdw1msecCounter &= MSECMASK;
	if(gdw1msecCounter % 10 == 0){
		gdw10msecCounter++;
		gdw10msecCounter &= MSECMASK;
		disk_timerproc();													// for FatFs Called in period of 10ms
		if(gdw10msecCounter % 10 == 0){
			gdw100msecCounter++;
			gdw100msecCounter &= MSECMASK;
			if(gdw100msecCounter % 10 == 0){
				gdw1000msecCounter++;
				gdw1000msecCounter &= MSECMASK;
			}
		}
	}
	return;
}

///////////////////////////////////////////////////////////////////////////
// Timer1̊荞݊֐ 1sec
///////////////////////////////////////////////////////////////////////////
void	Timer1IntHandler(void){
	//
	// Clear the timer interrupt.
	//
	ROM_TimerIntClear(TIMER1_BASE, TIMER_TIMA_TIMEOUT);

	gdw1usecCounter++;
	gdw1usecCounter &= MSECMASK;
	if(gdw1usecCounter % 10 == 0){
		gdw10usecCounter++;
		gdw10usecCounter &= MSECMASK;
		if(gdw10usecCounter % 10 == 0){
			gdw100usecCounter++;
			gdw100usecCounter &= MSECMASK;
		}
	}

	return;
}

///////////////////////////////////////////////////////////////////////////
// ^CAEgĂ邩`FbN֐
// 
//		CheckVal		: ݂̃JEgliex.gdw1msecCounterj
//		SavePoint		: ۑJEgl
//		TimeOutVal	: ^CAEgl
// ߂l
//		true : ^CAEg / false : ^CAEg
///////////////////////////////////////////////////////////////////////////
bool	CheckLoopTimeOut(DWORD CheckVal,DWORD SavePoint,DWORD TimeOutVal){
	DWORD	dwTmp;

	if(SavePoint > MSECMASK){
		// ̒l傫ƂƂ͂肦Ȃ̂Ń^CAEg
		return true;
	}
	dwTmp = CheckVal;
	if(dwTmp < SavePoint){
		// ݂̒lۑl菬ƂƂ́A[vĖ߂Ǝv
		dwTmp += MSECMASK;
	}
	if(dwTmp >= ( SavePoint + TimeOutVal )){
		// ݂̒lZ[u|Cg{^CAEgl傫  ^CAEg
		return true;
	} else {
		// ܂^CAEgł͂Ȃ
		return false;
	}
}

///////////////////////////////////////////////////////////////////////////
// ^CAEgĂ邩`FbN֐i1secj
// 
//		SavePoint		: ۑJEgl
//		TimeOutVal	: ^CAEgl
// ߂l
//		true : ^CAEg / false : ^CAEg
///////////////////////////////////////////////////////////////////////////
bool	CheckLoop1usecTimeOut(DWORD SavePoint,DWORD TimeOutVal){
	bool bTmp;
	bTmp = CheckLoopTimeOut(gdw1usecCounter,SavePoint,TimeOutVal);
	return bTmp;
}

///////////////////////////////////////////////////////////////////////////
// ^CAEgĂ邩`FbN֐i10secj
// 
//		SavePoint		: ۑJEgl
//		TimeOutVal	: ^CAEgl
// ߂l
//		true : ^CAEg / false : ^CAEg
///////////////////////////////////////////////////////////////////////////
bool	CheckLoop10usecTimeOut(DWORD SavePoint,DWORD TimeOutVal){
	bool bTmp;
	bTmp = CheckLoopTimeOut(gdw10usecCounter,SavePoint,TimeOutVal);
	return bTmp;
}

///////////////////////////////////////////////////////////////////////////
// ^CAEgĂ邩`FbN֐i100secj
// 
//		SavePoint		: ۑJEgl
//		TimeOutVal	: ^CAEgl
// ߂l
//		true : ^CAEg / false : ^CAEg
///////////////////////////////////////////////////////////////////////////
bool	CheckLoop100usecTimeOut(DWORD SavePoint,DWORD TimeOutVal){
	bool bTmp;
	bTmp = CheckLoopTimeOut(gdw100usecCounter,SavePoint,TimeOutVal);
	return bTmp;
}

///////////////////////////////////////////////////////////////////////////
// ^CAEgĂ邩`FbN֐i1msecj
// 
//		SavePoint		: ۑJEgl
//		TimeOutVal	: ^CAEgl
// ߂l
//		true : ^CAEg / false : ^CAEg
///////////////////////////////////////////////////////////////////////////
bool	CheckLoop1msecTimeOut(DWORD SavePoint,DWORD TimeOutVal){
	bool bTmp;
	bTmp = CheckLoopTimeOut(gdw1msecCounter,SavePoint,TimeOutVal);
	return bTmp;
}

///////////////////////////////////////////////////////////////////////////
// ^CAEgĂ邩`FbN֐i10msecj
// 
//		SavePoint		: ۑJEgl
//		TimeOutVal	: ^CAEgl
// ߂l
//		true : ^CAEg / false : ^CAEg
///////////////////////////////////////////////////////////////////////////
bool	CheckLoop10msecTimeOut(DWORD SavePoint,DWORD TimeOutVal){
	bool bTmp;
	bTmp = CheckLoopTimeOut(gdw10msecCounter,SavePoint,TimeOutVal);
	return bTmp;
}

///////////////////////////////////////////////////////////////////////////
// ^CAEgĂ邩`FbN֐i100msecj
// 
//		SavePoint		: ۑJEgl
//		TimeOutVal	: ^CAEgl
// ߂l
//		true : ^CAEg / false : ^CAEg
///////////////////////////////////////////////////////////////////////////
bool	CheckLoop100msecTimeOut(DWORD SavePoint,DWORD TimeOutVal){
	bool bTmp;
	bTmp = CheckLoopTimeOut(gdw100msecCounter,SavePoint,TimeOutVal);
	return bTmp;
}

///////////////////////////////////////////////////////////////////////////
// ^CAEgĂ邩`FbN֐i1000msecj
// 
//		SavePoint		: ۑJEgl
//		TimeOutVal	: ^CAEgl
// ߂l
//		true : ^CAEg / false : ^CAEg
///////////////////////////////////////////////////////////////////////////
bool	CheckLoop1000msecTimeOut(DWORD SavePoint,DWORD TimeOutVal){
	bool bTmp;
	bTmp = CheckLoopTimeOut(gdw1000msecCounter,SavePoint,TimeOutVal);
	return bTmp;
}

///////////////////////////////////////////////////////////////////////////
// ݂̃JEgl擾i1secj
// 
//		iV
// ߂l
//		݂̃JEgl
///////////////////////////////////////////////////////////////////////////
DWORD	Get1usecTimeCounter(void){
	return gdw1usecCounter;
}

///////////////////////////////////////////////////////////////////////////
// ݂̃JEgl擾i10secj
// 
//		iV
// ߂l
//		݂̃JEgl
///////////////////////////////////////////////////////////////////////////
DWORD	Get10usecTimeCounter(void){
	return gdw10usecCounter;
}

///////////////////////////////////////////////////////////////////////////
// ݂̃JEgl擾i100secj
// 
//		iV
// ߂l
//		݂̃JEgl
///////////////////////////////////////////////////////////////////////////
DWORD	Get100usecTimeCounter(void){
	return gdw100usecCounter;
}

///////////////////////////////////////////////////////////////////////////
// ݂̃JEgl擾i1msecj
// 
//		iV
// ߂l
//		݂̃JEgl
///////////////////////////////////////////////////////////////////////////
DWORD	Get1msecTimeCounter(void){
	return gdw1msecCounter;
}

///////////////////////////////////////////////////////////////////////////
// ݂̃JEgl擾i10msecj
// 
//		iV
// ߂l
//		݂̃JEgl
///////////////////////////////////////////////////////////////////////////
DWORD	Get10msecTimeCounter(void){
	return gdw10msecCounter;
}

///////////////////////////////////////////////////////////////////////////
// ݂̃JEgl擾i100msecj
// 
//		iV
// ߂l
//		݂̃JEgl
///////////////////////////////////////////////////////////////////////////
DWORD	Get100msecTimeCounter(void){
	return gdw100msecCounter;
}

///////////////////////////////////////////////////////////////////////////
// ݂̃JEgl擾i1000msecj
// 
//		iV
// ߂l
//		݂̃JEgl
///////////////////////////////////////////////////////////////////////////
DWORD	Get1000msecTimeCounter(void){
	return gdw1000msecCounter;
}

///////////////////////////////////////////////////////////////////////////
// X[vi1msecj  EHb`hbO^C}[ɋC邱
// 
//		SleepTime	: ҂
// ߂l
//		iV
///////////////////////////////////////////////////////////////////////////
void	Wait1msec(DWORD SleepTime){
	DWORD	dwCounter;
	DWORD	i = 0;
	dwCounter = Get1msecTimeCounter();
	while(CheckLoop1msecTimeOut(dwCounter,SleepTime) == false){
		// ҂
		i++;
	}
	return;
}

///////////////////////////////////////////////////////////////////////////
// X[vi1secj  EHb`hbO^C}[ɋC邱
// 
//		SleepTime	: ҂
// ߂l
//		iV
///////////////////////////////////////////////////////////////////////////
void	Wait1usec(DWORD SleepTime){
	DWORD	dwCounter;
	DWORD	i = 0;
	dwCounter = Get1usecTimeCounter();
	while(CheckLoop1usecTimeOut(dwCounter,SleepTime) == false){
		// ҂
		i++;
	}
	return;
}
