///////////////////////////////////////////////////////////////////////////
// ^b`pl(UART)
//
// 2015/12/22
///////////////////////////////////////////////////////////////////////////
#define	MONITOR_DEF_UART
#include "Monitorbase.h"

#define	TOUCH_BPS				(38400)
#define	UART_PORT				(UART6_BASE)
#define	INTP_PORT				(INT_UART6)

#define	USE_TOUCH_TIMER	(0)							// ̌oɃ^C}[gꍇ 1 wIDɂčlĂȂ̂Ŏgp鎞͒ӁI

#define	USE_MULTI_TOUCH	(0)							// }`^b`gp 1
#define	FINGER_NUMS			(USE_MULTI_TOUCH * 15 + 1)
BYTE	gbaTouchNow[FINGER_NUMS];
WORD	gwaTouchPosition[FINGER_NUMS][2];					// wAXY

#define	BUF_SIZE				(0x3F)
BYTE	gbaTouchBuf[BUF_SIZE + 1];				// Mobt@[
BYTE	gbTouchBufPosition = 0;

DWORD	gdwOneShotTimeout;

#define	MOVE_LIMIT			(5)							// 傫ړĂꍇړƂ

// Cxge֐n邽߂̃|C^[
static int32_t (*g_pfnTSHandler)(uint32_t ui32Message, int32_t i32X, int32_t i32Y);

const	BYTE	cbaMultiTouch[] = {					// }`^b`̐ݒ 0x04 / VO^b` 0x00
#if	USE_MULTI_TOUCH == 1		//[[[
	0xA3 , 0x02 , 0x04
#endif		//]]]
#if USE_MULTI_TOUCH == 0		//[[[
	0xA3 , 0x02 , 0x00
#endif		//]]]
};

bool	TouchSetCommand(const BYTE *pDat,BYTE bLength);

//////////////////////////////////////////////////////////// [[[
// ֐
//	
//		NbNݒ肵ۂ̖߂l
//	߂l
//		true / false
bool	TouchInit(uint32_t dwSysClock){
	BYTE	b;

	// Cxgnp̊֐͖`iʓr֐ĂԂƁj
	g_pfnTSHandler = 0;
	
	// ʐMx
	ROM_UARTConfigSetExpClk(UART_PORT,dwSysClock,TOUCH_BPS,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));

	// FIFŐ
	ROM_UARTFIFOEnable(UART_PORT);

	// 荞݂̋ݒ / RX:M / RT:M^CAEg
	ROM_UARTIntEnable(UART_PORT,(UART_INT_RX | UART_INT_RT));

#if USE_TOUCH_TIMER == 1		//[[[ vgRdlŗꂽꍇ̎擾\Ɖ̂ŃVbg^C}[폜 2015/12/24
	// gp
	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER2);
	// ^C}[ Vbg
	ROM_TimerConfigure(TIMER2_BASE,TIMER_CFG_ONE_SHOT | TIMER_CFG_A_ACT_CLRSETTO);
	// ̃Zbg SysCtlClockGet() = 1sec : 10msec = Clock / 100
	gdwOneShotTimeout = (DWORD)(dwSysClock / 100);		// œKiVƁÂ~܂Ă܂
	//gdwOneShotTimeout = 1200000;
	ROM_TimerLoadSet(TIMER2_BASE, TIMER_A, (uint32_t)gdwOneShotTimeout);
	// 荞݂̋
	ROM_IntEnable(INT_TIMER2A);
	ROM_TimerIntEnable(TIMER2_BASE, TIMER_TIMA_TIMEOUT);
#endif		//]]]
	
	// }`^b`̐ݒ著M
	TouchSetCommand(cbaMultiTouch,cbaMultiTouch[1]);
	
	for(b=0;b<FINGER_NUMS;b++){
		gbaTouchNow[b] = TOUCH_STATE_UP;
		gwaTouchPosition[b][0] = 0;
		gwaTouchPosition[b][1] = 0;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////
// 荞݋
// 
//		true :  / false : s
// ߂l
//		iV
///////////////////////////////////////////////////////////////////////////
void	TouchInterruptEnable(bool blFlag){
	if(blFlag == true){
		ROM_IntEnable(INTP_PORT);
	} else {
		ROM_IntDisable(INTP_PORT);
	}
	return;
}

///////////////////////////////////////////////////////////////////////////
// UART
// 
//		true :  / false : s
// ߂l
//		iV
///////////////////////////////////////////////////////////////////////////
void	TouchEnable(bool blFlag){
	if(blFlag == true){
		ROM_UARTEnable(UART_PORT);
	} else {
		ROM_UARTDisable(UART_PORT);
	}
	return;
}

///////////////////////////////////////////////////////////////////////////
// Mi`FbNŤvZtj
// 
//		Mf[^i`FbNTiVjւ̃|C^[A
// ߂l
//		usꍇAtrue
///////////////////////////////////////////////////////////////////////////
bool	TouchSetCommand(const BYTE *pDat,BYTE bLength){
	bool	bRet = false;
	BYTE	bChrPos;;
	WORD	wCheckSum = 0;

	if(ROM_UARTBusy(UART_PORT) == false){
		// ZȂ悤Ȃ̂ŏs
		IntDisable(INTP_PORT);												// 荞݋֎~
		for(bChrPos=0;bChrPos<bLength;bChrPos++){
			ROM_UARTCharPut(UART_PORT,*(pDat + bChrPos));
			wCheckSum += *(pDat + bChrPos);
		}
		ROM_UARTCharPut(UART_PORT,(BYTE)(wCheckSum & 0x007F));		// `FbNT
		ROM_UARTCharPut(UART_PORT,0x00);
		IntEnable(INTP_PORT);													// 荞݋֎~
		bRet = true;
	}
	return bRet;
}


///////////////////////////////////////////////////////////////////////////
// M荞ݏ
///////////////////////////////////////////////////////////////////////////
void	UartRxGetIntHandler(void){
	DWORD	dwIntStat;
	DWORD	dwGetData;
	//BYTE	baBuf[64];
	//BYTE	bPos = 0;
	WORD	wPositX = 0;
	WORD	wPositY = 0;
	BYTE	bGet = 0xFF;
	bool	blValGet = false;
	bool	blMove;
	BYTE	bFingerID = 0;
	bool	blRelease = false;			// ꂽAtrue

	// 荞ݗv̎擾 false(raw)͗vȂ̂H
	dwIntStat = ROM_UARTIntStatus(UART_PORT,true);
	// 荞݃tÕNA
	ROM_UARTIntClear(UART_PORT,dwIntStat);

	while(ROM_UARTCharsAvail(UART_PORT)){
		// Mf[^A
		dwGetData = ROM_UARTCharGetNonBlocking(UART_PORT);					// Mf[^̎擾
		/*
		gbaTouchBuf[gwTouchBufPosition] = (BYTE)dw;
		gwTouchBufPosition++;
		gwTouchBufPosition &= 0x3FF;
		*/
		gbaTouchBuf[gbTouchBufPosition] = (BYTE)dwGetData;
		if((BYTE)(dwGetData & 0x00C0) == 0x80){										// 0x8X Ŏwo
			if(gbTouchBufPosition >= 3){
				if( (gbaTouchBuf[gbTouchBufPosition-1] == 0x14) &&		// Œl
					 	(gbaTouchBuf[gbTouchBufPosition-2] == 0x07) &&		// 
						(gbaTouchBuf[gbTouchBufPosition-3] == 0xDC) ){		// wb_[
					bGet = 0;
#if USE_MULTI_TOUCH == 1		//[[[
					bFingerID = (BYTE)(dwGetData & 0x03C) >> 2;
#endif		//]]]
					if((BYTE)(dwGetData & 0x001) == 0){
						blRelease = true;
					}
				}
			}
		}
		if(bGet != 0xFF){	bGet++;	}
		if(bGet == 4){
			if(gbTouchBufPosition > 3){
				wPositX = MAKEWORD(gbaTouchBuf[gbTouchBufPosition],gbaTouchBuf[gbTouchBufPosition-1]);
				wPositY = MAKEWORD(gbaTouchBuf[gbTouchBufPosition-2],gbaTouchBuf[gbTouchBufPosition-3]);
				blValGet = true;
			}
		}
		gbTouchBufPosition++;
		gbTouchBufPosition &= BUF_SIZE;
	}
	if(blValGet == true){
		wPositX = (WORD)(wPositX / 20.24);				// 0`3F3FȂ̂20.24ŊƍWoĂitj
		wPositY = (WORD)(wPositY / 33.74);				// 0`3F3FȂ̂33.733...ŊƍWoĂ
		if(wPositX >= 800){	wPositX = 799;	}
		if(wPositY >= 480){	wPositY = 479;	}
		wPositX = 800 - wPositX;
		blMove = false;									// ړ̔
		if(gwaTouchPosition[bFingerID][0] > wPositX){
			if(gwaTouchPosition[bFingerID][0] - wPositX > MOVE_LIMIT){
				blMove = true;
			}
		} else {
			if(wPositX - gwaTouchPosition[bFingerID][0] > MOVE_LIMIT){
				blMove = true;
			}
		}
		if(gwaTouchPosition[bFingerID][1] > wPositY){
			if(gwaTouchPosition[bFingerID][1] - wPositY > MOVE_LIMIT){
				blMove = true;
			}
		} else {
			if(wPositY - gwaTouchPosition[bFingerID][1] > MOVE_LIMIT){
				blMove = true;
			}
		}																// ړ̔i܂Łj
		gwaTouchPosition[bFingerID][0] = wPositX;
		gwaTouchPosition[bFingerID][1] = wPositY;
		switch(gbaTouchNow[bFingerID]){
		case TOUCH_STATE_DOWN:
			if(blMove == true){						// WقȂ̂ňړ
				if(blRelease == true){			// wꂽ
					gbaTouchNow[bFingerID] = TOUCH_STATE_UP;
				} else {
					gbaTouchNow[bFingerID] = TOUCH_STATE_MOVE;
				}
				if(g_pfnTSHandler){					// Cxgn
					g_pfnTSHandler(gbaTouchNow[bFingerID], gwaTouchPosition[bFingerID][0], gwaTouchPosition[bFingerID][1]);
				}
			} else {
				if(blRelease == true){			// wꂽ
					gbaTouchNow[bFingerID] = TOUCH_STATE_UP;
					if(g_pfnTSHandler){				// Cxgn
						g_pfnTSHandler(gbaTouchNow[bFingerID], gwaTouchPosition[bFingerID][0], gwaTouchPosition[bFingerID][1]);
					}
				}
			}
			break;
		case TOUCH_STATE_MOVE:
			if(blMove == false){					// WقȂ̂ňړĂȂ
				//gbaTouchNow[0] = TOUCH_STATE_DOWN;
				//if(g_pfnTSHandler){					// Cxgn
				//	g_pfnTSHandler(gbaTouchNow[0], gwaTouchPosition[0][0], gwaTouchPosition[0][1]);
				//}
			}
			if(blRelease == true){				// wꂽ
				gbaTouchNow[bFingerID] = TOUCH_STATE_UP;
				if(g_pfnTSHandler){					// Cxgn
					g_pfnTSHandler(gbaTouchNow[bFingerID], gwaTouchPosition[bFingerID][0], gwaTouchPosition[bFingerID][1]);
				}
			}
			break;
		case TOUCH_STATE_UP:
			gbaTouchNow[bFingerID] = TOUCH_STATE_DOWN;
			if(g_pfnTSHandler){						// Cxgn
				g_pfnTSHandler(gbaTouchNow[bFingerID], gwaTouchPosition[bFingerID][0], gwaTouchPosition[bFingerID][1]);
			}
			break;
		}
		gbTouchBufPosition = 0;
	}
	//gblTouchNow[0] = blValGet;			// ^b`Ԃ̎擾ɂȂ邩ƎvA͍sȂ͗l

#if USE_TOUCH_TIMER == 1		//[[[
	ROM_TimerDisable(TIMER2_BASE,TIMER_A);
	ROM_TimerLoadSet(TIMER2_BASE, TIMER_A, (uint32_t)gdwOneShotTimeout);
	ROM_TimerEnable(TIMER2_BASE,TIMER_A);
#endif		//]]]
	return;
}

///////////////////////////////////////////////////////////////////////////
// Vbg^C}[荞ݏ
///////////////////////////////////////////////////////////////////////////
#if USE_TOUCH_TIMER == 1		//[[[
void	OneShotIntHandler(void){
	ROM_TimerIntClear(TIMER2_BASE, TIMER_TIMA_TIMEOUT);
	ROM_TimerDisable(TIMER2_BASE,TIMER_A);

	gbaTouchNow[0] = TOUCH_STATE_UP;
	if(g_pfnTSHandler){								// Cxgn
		g_pfnTSHandler(gbaTouchNow[0], gwaTouchPosition[0][0], gwaTouchPosition[0][1]);
	}
	return;
}
#endif		//]]]

///////////////////////////////////////////////////////////////////////////
// Cxgnp֐̃ZbgiUPADWONAMOVEƍWn邱ƂɂȂj
///////////////////////////////////////////////////////////////////////////
void	TouchScreenCallbackSet(int32_t (*pfnCallback)(uint32_t ui32Message, int32_t i32X, int32_t i32Y)){
	// Save the pointer to the callback function.
	g_pfnTSHandler = pfnCallback;
	return;
}
