//*****************************************************************************
//
// pinout.c - Function to configure the device pins on the DK-TM4C129X.
//
// Copyright (c) 2013 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.0 of the DK-TM4C129X Firmware Package.
//
//*****************************************************************************

#include <stdbool.h>
#include <stdint.h>
#include "inc/hw_gpio.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
//#include "driverlib/rom.h"						// 2015/11/11 MonitorpɃRgAEg
#include "driverlib/rom_map.h"					// 2015/11/11 Monitorpɒǉ
#include "driverlib/sysctl.h"
#include "drivers/pinout.h"

//*****************************************************************************
//
//! \addtogroup pinout_api
//! @{
//
//*****************************************************************************

//*****************************************************************************
//
//! Configures the device pins for the standard usages on the DK-TM4C129X.
//!
//! This function enables the GPIO modules and configures the device pins for
//! the default, standard usages on the DK-TM4C129X.  Applications that require
//! alternate configurations of the device pins can either not call this
//! function and take full responsibility for configuring all the device pins,
//! or can reconfigure the required device pins after calling this function.
//!
//! \return None.
//
//*****************************************************************************
void
PinoutSet(void)
{
	// Monitorp
    //
    // Enable Peripheral Clocks 
    //
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_SSI0);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_LCD0);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_UART6);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_SSI2);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_EPI0);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_CAN0);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_USB0);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_SSI1);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_PWM0);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOG);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOH);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOJ);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOK);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOL);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOM);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPION);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOP);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOQ);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOR);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOS);
    MAP_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOT);

    //
    // Enable pin PA0 for CAN0 CAN0RX
    //
    MAP_GPIOPinConfigure(GPIO_PA0_CAN0RX);
    MAP_GPIOPinTypeCAN(GPIO_PORTA_BASE, GPIO_PIN_0);

    //
    // Enable pin PA1 for CAN0 CAN0TX
    //
    MAP_GPIOPinConfigure(GPIO_PA1_CAN0TX);
    MAP_GPIOPinTypeCAN(GPIO_PORTA_BASE, GPIO_PIN_1);

    //
    // Enable pin PQ4 for DIVSCLK0 DIVSCLK
    //
    MAP_GPIOPinConfigure(GPIO_PQ4_DIVSCLK);
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTQ_BASE, GPIO_PIN_4);

    //
    // Enable pin PL1 for EPI0 EPI0S17
    //
    MAP_GPIOPinConfigure(GPIO_PL1_EPI0S17);
    MAP_GPIOPinTypeEPI(GPIO_PORTL_BASE, GPIO_PIN_1);

    //
    // Enable pin PC4 for EPI0 EPI0S7
    //
    MAP_GPIOPinConfigure(GPIO_PC4_EPI0S7);
    MAP_GPIOPinTypeEPI(GPIO_PORTC_BASE, GPIO_PIN_4);

    //
    // Enable pin PM0 for EPI0 EPI0S15
    //
    MAP_GPIOPinConfigure(GPIO_PM0_EPI0S15);
    MAP_GPIOPinTypeEPI(GPIO_PORTM_BASE, GPIO_PIN_0);

    //
    // Enable pin PK5 for EPI0 EPI0S31
    //
    MAP_GPIOPinConfigure(GPIO_PK5_EPI0S31);
    MAP_GPIOPinTypeEPI(GPIO_PORTK_BASE, GPIO_PIN_5);

    //
    // Enable pin PM2 for EPI0 EPI0S13
    //
    MAP_GPIOPinConfigure(GPIO_PM2_EPI0S13);
    MAP_GPIOPinTypeEPI(GPIO_PORTM_BASE, GPIO_PIN_2);

    //
    // Enable pin PB3 for EPI0 EPI0S28
    //
    MAP_GPIOPinConfigure(GPIO_PB3_EPI0S28);
    MAP_GPIOPinTypeEPI(GPIO_PORTB_BASE, GPIO_PIN_3);

    //
    // Enable pin PG1 for EPI0 EPI0S10
    //
    MAP_GPIOPinConfigure(GPIO_PG1_EPI0S10);
    MAP_GPIOPinTypeEPI(GPIO_PORTG_BASE, GPIO_PIN_1);

    //
    // Enable pin PH1 for EPI0 EPI0S1
    //
    MAP_GPIOPinConfigure(GPIO_PH1_EPI0S1);
    MAP_GPIOPinTypeEPI(GPIO_PORTH_BASE, GPIO_PIN_1);

    //
    // Enable pin PA7 for EPI0 EPI0S9
    //
    MAP_GPIOPinConfigure(GPIO_PA7_EPI0S9);
    MAP_GPIOPinTypeEPI(GPIO_PORTA_BASE, GPIO_PIN_7);

    //
    // Enable pin PH3 for EPI0 EPI0S3
    //
    MAP_GPIOPinConfigure(GPIO_PH3_EPI0S3);
    MAP_GPIOPinTypeEPI(GPIO_PORTH_BASE, GPIO_PIN_3);

    //
    // Enable pin PC5 for EPI0 EPI0S6
    //
    MAP_GPIOPinConfigure(GPIO_PC5_EPI0S6);
    MAP_GPIOPinTypeEPI(GPIO_PORTC_BASE, GPIO_PIN_5);

    //
    // Enable pin PN2 for EPI0 EPI0S29
    //
    MAP_GPIOPinConfigure(GPIO_PN2_EPI0S29);
    MAP_GPIOPinTypeEPI(GPIO_PORTN_BASE, GPIO_PIN_2);

    //
    // Enable pin PN3 for EPI0 EPI0S30
    //
    MAP_GPIOPinConfigure(GPIO_PN3_EPI0S30);
    MAP_GPIOPinTypeEPI(GPIO_PORTN_BASE, GPIO_PIN_3);

    //
    // Enable pin PG0 for EPI0 EPI0S11
    //
    MAP_GPIOPinConfigure(GPIO_PG0_EPI0S11);
    MAP_GPIOPinTypeEPI(GPIO_PORTG_BASE, GPIO_PIN_0);

    //
    // Enable pin PH0 for EPI0 EPI0S0
    //
    MAP_GPIOPinConfigure(GPIO_PH0_EPI0S0);
    MAP_GPIOPinTypeEPI(GPIO_PORTH_BASE, GPIO_PIN_0);

    //
    // Enable pin PL2 for EPI0 EPI0S18
    //
    MAP_GPIOPinConfigure(GPIO_PL2_EPI0S18);
    MAP_GPIOPinTypeEPI(GPIO_PORTL_BASE, GPIO_PIN_2);

    //
    // Enable pin PC7 for EPI0 EPI0S4
    //
    MAP_GPIOPinConfigure(GPIO_PC7_EPI0S4);
    MAP_GPIOPinTypeEPI(GPIO_PORTC_BASE, GPIO_PIN_7);

    //
    // Enable pin PA6 for EPI0 EPI0S8
    //
    MAP_GPIOPinConfigure(GPIO_PA6_EPI0S8);
    MAP_GPIOPinTypeEPI(GPIO_PORTA_BASE, GPIO_PIN_6);

    //
    // Enable pin PH2 for EPI0 EPI0S2
    //
    MAP_GPIOPinConfigure(GPIO_PH2_EPI0S2);
    MAP_GPIOPinTypeEPI(GPIO_PORTH_BASE, GPIO_PIN_2);

    //
    // Enable pin PL3 for EPI0 EPI0S19
    //
    MAP_GPIOPinConfigure(GPIO_PL3_EPI0S19);
    MAP_GPIOPinTypeEPI(GPIO_PORTL_BASE, GPIO_PIN_3);

    //
    // Enable pin PC6 for EPI0 EPI0S5
    //
    MAP_GPIOPinConfigure(GPIO_PC6_EPI0S5);
    MAP_GPIOPinTypeEPI(GPIO_PORTC_BASE, GPIO_PIN_6);

    //
    // Enable pin PM3 for EPI0 EPI0S12
    //
    MAP_GPIOPinConfigure(GPIO_PM3_EPI0S12);
    MAP_GPIOPinTypeEPI(GPIO_PORTM_BASE, GPIO_PIN_3);

    //
    // Enable pin PM1 for EPI0 EPI0S14
    //
    MAP_GPIOPinConfigure(GPIO_PM1_EPI0S14);
    MAP_GPIOPinTypeEPI(GPIO_PORTM_BASE, GPIO_PIN_1);

    //
    // Enable pin PL0 for EPI0 EPI0S16
    //
    MAP_GPIOPinConfigure(GPIO_PL0_EPI0S16);
    MAP_GPIOPinTypeEPI(GPIO_PORTL_BASE, GPIO_PIN_0);

    //
    // Enable pin PA3 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_3);

    //
    // Enable pin PB7 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTB_BASE, GPIO_PIN_7);

    //
    // Enable pin PB6 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTB_BASE, GPIO_PIN_6);

    //
    // Enable pin PB4 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTB_BASE, GPIO_PIN_4);

    //
    // Enable pin PB2 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTB_BASE, GPIO_PIN_2);

    //
    // Enable pin PD2 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTD_BASE, GPIO_PIN_2);

    //
    // Enable pin PE1 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTE_BASE, GPIO_PIN_1);

    //
    // Enable pin PE6 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_6);

    //
    // Enable pin PE2 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTE_BASE, GPIO_PIN_2);

    //
    // Enable pin PE7 for GPIOOutput
    //

    //
    //First open the lock and select the bits we want to modify in the GPIO commit register.
    //
    HWREG(GPIO_PORTE_BASE + GPIO_O_LOCK) = GPIO_LOCK_KEY;
    HWREG(GPIO_PORTE_BASE + GPIO_O_CR) = 0x80;

    //
    //Now modify the configuration of the pins that we unlocked.
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_7);

    //
    // Enable pin PE3 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTE_BASE, GPIO_PIN_3);

    //
    // Enable pin PE0 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTE_BASE, GPIO_PIN_0);

    //
    // Enable pin PF4 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_4);

    //
    // Enable pin PF5 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_5);

    //
    // Enable pin PF1 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTF_BASE, GPIO_PIN_1);

    //
    // Enable pin PH6 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTH_BASE, GPIO_PIN_6);

    //
    // Enable pin PH5 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTH_BASE, GPIO_PIN_5);

    //
    // Enable pin PH7 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTH_BASE, GPIO_PIN_7);

    //
    // Enable pin PK7 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTK_BASE, GPIO_PIN_7);

    //
    // Enable pin PK1 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTK_BASE, GPIO_PIN_1);

    //
    // Enable pin PK2 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTK_BASE, GPIO_PIN_2);

    //
    // Enable pin PK3 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTK_BASE, GPIO_PIN_3);

    //
    // Enable pin PK0 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTK_BASE, GPIO_PIN_0);

    //
    // Enable pin PN1 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_1);

    //
    // Enable pin PN5 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_5);

    //
    // Enable pin PN0 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_0);

    //
    // Enable pin PN4 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTN_BASE, GPIO_PIN_4);

    //
    // Enable pin PP6 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTP_BASE, GPIO_PIN_6);

    //
    // Enable pin PP7 for GPIOInput
    //
    MAP_GPIOPinTypeGPIOInput(GPIO_PORTP_BASE, GPIO_PIN_7);

    //
    // Enable pin PQ1 for GPIOOutput
    //
    MAP_GPIOPinTypeGPIOOutput(GPIO_PORTQ_BASE, GPIO_PIN_1);

    //
    // Enable pin PS5 for LCD0 LCDDATA07
    //
    MAP_GPIOPinConfigure(GPIO_PS5_LCDDATA07);
    MAP_GPIOPinTypeLCD(GPIO_PORTS_BASE, GPIO_PIN_5);

    //
    // Enable pin PT2 for LCD0 LCDDATA18
    //
    MAP_GPIOPinConfigure(GPIO_PT2_LCDDATA18);
    MAP_GPIOPinTypeLCD(GPIO_PORTT_BASE, GPIO_PIN_2);

    //
    // Enable pin PS6 for LCD0 LCDDATA08
    //
    MAP_GPIOPinConfigure(GPIO_PS6_LCDDATA08);
    MAP_GPIOPinTypeLCD(GPIO_PORTS_BASE, GPIO_PIN_6);

    //
    // Enable pin PR4 for LCD0 LCDDATA00
    //
    MAP_GPIOPinConfigure(GPIO_PR4_LCDDATA00);
    MAP_GPIOPinTypeLCD(GPIO_PORTR_BASE, GPIO_PIN_4);

    //
    // Enable pin PJ6 for LCD0 LCDAC
    //
    MAP_GPIOPinConfigure(GPIO_PJ6_LCDAC);
    MAP_GPIOPinTypeLCD(GPIO_PORTJ_BASE, GPIO_PIN_6);

    //
    // Enable pin PN6 for LCD0 LCDDATA13
    //
    MAP_GPIOPinConfigure(GPIO_PN6_LCDDATA13);
    MAP_GPIOPinTypeLCD(GPIO_PORTN_BASE, GPIO_PIN_6);

    //
    // Enable pin PJ4 for LCD0 LCDDATA16
    //
    MAP_GPIOPinConfigure(GPIO_PJ4_LCDDATA16);
    MAP_GPIOPinTypeLCD(GPIO_PORTJ_BASE, GPIO_PIN_4);

    //
    // Enable pin PS1 for LCD0 LCDDATA21
    //
    MAP_GPIOPinConfigure(GPIO_PS1_LCDDATA21);
    MAP_GPIOPinTypeLCD(GPIO_PORTS_BASE, GPIO_PIN_1);

    //
    // Enable pin PR0 for LCD0 LCDCP
    //
    MAP_GPIOPinConfigure(GPIO_PR0_LCDCP);
    MAP_GPIOPinTypeLCD(GPIO_PORTR_BASE, GPIO_PIN_0);

    //
    // Enable pin PR5 for LCD0 LCDDATA01
    //
    MAP_GPIOPinConfigure(GPIO_PR5_LCDDATA01);
    MAP_GPIOPinTypeLCD(GPIO_PORTR_BASE, GPIO_PIN_5);

    //
    // Enable pin PR1 for LCD0 LCDFP
    //
    MAP_GPIOPinConfigure(GPIO_PR1_LCDFP);
    MAP_GPIOPinTypeLCD(GPIO_PORTR_BASE, GPIO_PIN_1);

    //
    // Enable pin PR7 for LCD0 LCDDATA05
    //
    MAP_GPIOPinConfigure(GPIO_PR7_LCDDATA05);
    MAP_GPIOPinTypeLCD(GPIO_PORTR_BASE, GPIO_PIN_7);

    //
    // Enable pin PR2 for LCD0 LCDLP
    //
    MAP_GPIOPinConfigure(GPIO_PR2_LCDLP);
    MAP_GPIOPinTypeLCD(GPIO_PORTR_BASE, GPIO_PIN_2);

    //
    // Enable pin PN7 for LCD0 LCDDATA12
    //
    MAP_GPIOPinConfigure(GPIO_PN7_LCDDATA12);
    MAP_GPIOPinTypeLCD(GPIO_PORTN_BASE, GPIO_PIN_7);

    //
    // Enable pin PT1 for LCD0 LCDDATA11
    //
    MAP_GPIOPinConfigure(GPIO_PT1_LCDDATA11);
    MAP_GPIOPinTypeLCD(GPIO_PORTT_BASE, GPIO_PIN_1);

    //
    // Enable pin PR3 for LCD0 LCDDATA03
    //
    MAP_GPIOPinConfigure(GPIO_PR3_LCDDATA03);
    MAP_GPIOPinTypeLCD(GPIO_PORTR_BASE, GPIO_PIN_3);

    //
    // Enable pin PR6 for LCD0 LCDDATA04
    //
    MAP_GPIOPinConfigure(GPIO_PR6_LCDDATA04);
    MAP_GPIOPinTypeLCD(GPIO_PORTR_BASE, GPIO_PIN_6);

    //
    // Enable pin PJ3 for LCD0 LCDDATA15
    //
    MAP_GPIOPinConfigure(GPIO_PJ3_LCDDATA15);
    MAP_GPIOPinTypeLCD(GPIO_PORTJ_BASE, GPIO_PIN_3);

    //
    // Enable pin PS7 for LCD0 LCDDATA09
    //
    MAP_GPIOPinConfigure(GPIO_PS7_LCDDATA09);
    MAP_GPIOPinTypeLCD(GPIO_PORTS_BASE, GPIO_PIN_7);

    //
    // Enable pin PS0 for LCD0 LCDDATA20
    //
    MAP_GPIOPinConfigure(GPIO_PS0_LCDDATA20);
    MAP_GPIOPinTypeLCD(GPIO_PORTS_BASE, GPIO_PIN_0);

    //
    // Enable pin PJ5 for LCD0 LCDDATA17
    //
    MAP_GPIOPinConfigure(GPIO_PJ5_LCDDATA17);
    MAP_GPIOPinTypeLCD(GPIO_PORTJ_BASE, GPIO_PIN_5);

    //
    // Enable pin PS3 for LCD0 LCDDATA23
    //
    MAP_GPIOPinConfigure(GPIO_PS3_LCDDATA23);
    MAP_GPIOPinTypeLCD(GPIO_PORTS_BASE, GPIO_PIN_3);

    //
    // Enable pin PF7 for LCD0 LCDDATA02
    //
    MAP_GPIOPinConfigure(GPIO_PF7_LCDDATA02);
    MAP_GPIOPinTypeLCD(GPIO_PORTF_BASE, GPIO_PIN_7);

    //
    // Enable pin PS4 for LCD0 LCDDATA06
    //
    MAP_GPIOPinConfigure(GPIO_PS4_LCDDATA06);
    MAP_GPIOPinTypeLCD(GPIO_PORTS_BASE, GPIO_PIN_4);

    //
    // Enable pin PS2 for LCD0 LCDDATA22
    //
    MAP_GPIOPinConfigure(GPIO_PS2_LCDDATA22);
    MAP_GPIOPinTypeLCD(GPIO_PORTS_BASE, GPIO_PIN_2);

    //
    // Enable pin PT0 for LCD0 LCDDATA10
    //
    MAP_GPIOPinConfigure(GPIO_PT0_LCDDATA10);
    MAP_GPIOPinTypeLCD(GPIO_PORTT_BASE, GPIO_PIN_0);

    //
    // Enable pin PJ2 for LCD0 LCDDATA14
    //
    MAP_GPIOPinConfigure(GPIO_PJ2_LCDDATA14);
    MAP_GPIOPinTypeLCD(GPIO_PORTJ_BASE, GPIO_PIN_2);

    //
    // Enable pin PT3 for LCD0 LCDDATA19
    //
    MAP_GPIOPinConfigure(GPIO_PT3_LCDDATA19);
    MAP_GPIOPinTypeLCD(GPIO_PORTT_BASE, GPIO_PIN_3);

    //
    // Enable pin PF2 for PWM0 M0PWM2
    //
    MAP_GPIOPinConfigure(GPIO_PF2_M0PWM2);
    MAP_GPIOPinTypePWM(GPIO_PORTF_BASE, GPIO_PIN_2);

    //
    // Enable pin PA4 for SSI0 SSI0XDAT0
    //
    MAP_GPIOPinConfigure(GPIO_PA4_SSI0XDAT0);
    MAP_GPIOPinTypeSSI(GPIO_PORTA_BASE, GPIO_PIN_4);

    //
    // Enable pin PA2 for SSI0 SSI0CLK
    //
    MAP_GPIOPinConfigure(GPIO_PA2_SSI0CLK);
    MAP_GPIOPinTypeSSI(GPIO_PORTA_BASE, GPIO_PIN_2);

    //
    // Enable pin PA5 for SSI0 SSI0XDAT1
    //
    MAP_GPIOPinConfigure(GPIO_PA5_SSI0XDAT1);
    MAP_GPIOPinTypeSSI(GPIO_PORTA_BASE, GPIO_PIN_5);

    //
    // Enable pin PD5 for SSI1 SSI1XDAT3
    //
    MAP_GPIOPinConfigure(GPIO_PD5_SSI1XDAT3);
    MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_5);

    //
    // Enable pin PD4 for SSI1 SSI1XDAT2
    //
    MAP_GPIOPinConfigure(GPIO_PD4_SSI1XDAT2);
    MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_4);

    //
    // Enable pin PE5 for SSI1 SSI1XDAT1
    //
    MAP_GPIOPinConfigure(GPIO_PE5_SSI1XDAT1);
    MAP_GPIOPinTypeSSI(GPIO_PORTE_BASE, GPIO_PIN_5);

    //
    // Enable pin PB5 for SSI1 SSI1CLK
    //
    MAP_GPIOPinConfigure(GPIO_PB5_SSI1CLK);
    MAP_GPIOPinTypeSSI(GPIO_PORTB_BASE, GPIO_PIN_5);

    //
    // Enable pin PE4 for SSI1 SSI1XDAT0
    //
    MAP_GPIOPinConfigure(GPIO_PE4_SSI1XDAT0);
    MAP_GPIOPinTypeSSI(GPIO_PORTE_BASE, GPIO_PIN_4);

    //
    // Enable pin PD1 for SSI2 SSI2XDAT0
    //
    MAP_GPIOPinConfigure(GPIO_PD1_SSI2XDAT0);
    MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_1);

    //
    // Enable pin PD3 for SSI2 SSI2CLK
    //
    MAP_GPIOPinConfigure(GPIO_PD3_SSI2CLK);
    MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_3);

    //
    // Enable pin PD0 for SSI2 SSI2XDAT1
    //
    MAP_GPIOPinConfigure(GPIO_PD0_SSI2XDAT1);
    MAP_GPIOPinTypeSSI(GPIO_PORTD_BASE, GPIO_PIN_0);

    //
    // Enable pin PP1 for UART6 U6TX
    //
    MAP_GPIOPinConfigure(GPIO_PP1_U6TX);
    MAP_GPIOPinTypeUART(GPIO_PORTP_BASE, GPIO_PIN_1);

    //
    // Enable pin PP0 for UART6 U6RX
    //
    MAP_GPIOPinConfigure(GPIO_PP0_U6RX);
    MAP_GPIOPinTypeUART(GPIO_PORTP_BASE, GPIO_PIN_0);

    //
    // Enable pin PD7 for USB0 USB0PFLT
    // First open the lock and select the bits we want to modify in the GPIO commit register.
    //
    HWREG(GPIO_PORTD_BASE + GPIO_O_LOCK) = GPIO_LOCK_KEY;
    HWREG(GPIO_PORTD_BASE + GPIO_O_CR) = 0x80;

    //
    // Now modify the configuration of the pins that we unlocked.
    //
    MAP_GPIOPinConfigure(GPIO_PD7_USB0PFLT);
    MAP_GPIOPinTypeUSBDigital(GPIO_PORTD_BASE, GPIO_PIN_7);

    //
    // Enable pin PD6 for USB0 USB0EPEN
    //
    MAP_GPIOPinConfigure(GPIO_PD6_USB0EPEN);
    MAP_GPIOPinTypeUSBDigital(GPIO_PORTD_BASE, GPIO_PIN_6);

    //
    // Enable pin PL7 for USB0 USB0DM
    //
    MAP_GPIOPinTypeUSBAnalog(GPIO_PORTL_BASE, GPIO_PIN_7);

    //
    // Enable pin PL6 for USB0 USB0DP
    //
    MAP_GPIOPinTypeUSBAnalog(GPIO_PORTL_BASE, GPIO_PIN_6);

    //
    // Enable pin PB0 for USB0 USB0ID
    //
    MAP_GPIOPinTypeUSBAnalog(GPIO_PORTB_BASE, GPIO_PIN_0);

    //
    // Enable pin PB1 for USB0 USB0VBUS
    //
    MAP_GPIOPinTypeUSBAnalog(GPIO_PORTB_BASE, GPIO_PIN_1);
}

//*****************************************************************************
//
// Close the Doxygen group.
//! @}
//
//*****************************************************************************
