/*
 * host_comm.cpp
 *
 *  Created on: Aug 25, 2016
 *      Author: yli
 */


#include "host_comm.h"
#include "ndk_test_defines.h"
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/task.h>
#include "tiva_timer.h"
#include "tiva_emac.h"

bool g_print_phy_regs = false;

void HostComm::Main()
{
    PRINTFD("Host Comm Task Started. Starting Message Exchange\n");

    TivaTimer::Init();

    while(1)
    {
        NetworkInterface::MaintainLink();
        NetworkInterface::SendReceive();

        if(g_print_phy_regs)
        {
            TIVAEMAC::PrintPHYRegs();
            g_print_phy_regs = false;
        }
    }
}

extern "C"
{

/******************************************************************************
* This is the C entry function for the Host Communication task.  DSP/BIOS will call
* this function.  Host Comm Task handles BLE, Wifi, and Ethernet communication
* to host.  USB communication are handled in separate Tasks due to the complexity
* of USB MTP and low latency requirement of USB HID.
******************************************************************************/
void HostCommTask()
{
    HostComm::Main();
}

}
