/*
 * ndk_interface.h
 *
 *  Created on: Jun 21, 2016
 *      Author: yli
 */

#ifndef INCLUDE_NDK_INTERFACE_H_
#define INCLUDE_NDK_INTERFACE_H_

#include <stdint.h>
#include <stdbool.h>
#include "sys/socket.h"

#define NDK_DNSBUFSIZE 512

#ifdef __cplusplus
extern "C"
{
#endif
int call_ndk_accept(int socket_handle, struct sockaddr *addr, socklen_t *addrlen);
int call_ndk_bind(int socket_handle, struct sockaddr *p_addr, socklen_t addrlen);
int call_ndk_connect(int socket_handle, struct sockaddr *p_addr, socklen_t addrlen);
int call_ndk_listen(int socket_handle, int maxcon);
int call_ndk_recv(int tcp_handle, void *p_data, int size, int flags);
int call_ndk_recvfrom(int socket_handle, void *p_data, int size, int flags, struct sockaddr *p_addr, socklen_t *p_addrlen);
int call_ndk_recvnc(int tcp_handle, void **p_data, int flags, void **phBuffer);
void call_ndk_recvncfree(void *hBuffer);
int call_ndk_close(int tcp_handle);
int call_setsockopt(int socket_handle, int level, int optname, const void *optval, socklen_t optlen);
int call_ndk_socket(int domain, int type, int protocol);
int call_ndk_send(int socket_handle, const void *p_data, int size, int flags);
ssize_t call_ndk_sendto(int socket_handle, const void *p_data, size_t len, int flags,
        const struct sockaddr *to, socklen_t tolen);
int call_fdError();
int call_fdOpenSession( void *hTask );
void call_fdCloseSession( void *hTask );
void *call_TaskSelf();
bool RestartNDKDHCP();
bool SpecifyIPNetwork(uint32_t ip_addr, uint32_t subnet_msk);
bool RemoveStaticIP();
bool DisableNDKDHCP();
bool StartNDKDHCP();
void AddRTCHook(void (*pfn)( uint32_t, uint32_t, uint32_t ));
bool NDK_GetHostIPByName(char *p_h_name, uint32_t *p_ip_addr);

#ifdef __cplusplus
}
#endif

#endif /* INCLUDE_NDK_INTERFACE_H_ */
