/*
 * network_data.h
 *
 *  Created on: Jun 24, 2016
 *      Author: yli
 */

#ifndef INCLUDE_NETWORK_DATA_H_
#define INCLUDE_NETWORK_DATA_H_

#include <stdint.h>

    typedef enum{
        ETHERNET_INTF = 0,
        WIFI_INTF
    }Interface_t;

#pragma pack (push,1)

class NetworkData
{
public:
    NetworkData();
    ~NetworkData();

    uint32_t client_addr;   // IP address of remote device.
    uint16_t port_num;
    uint16_t remote_port_num; // client port num
    uint8_t  client_id;     // client ID
    Interface_t  interface;
    uint8_t  protocol;      // see NetworkInterface header for interface definition
    uint32_t data_size;     // size of data in bytes
    void     *p_socket;     // socket pointer
    uint8_t  *p_data;
};

#pragma pack (pop)

#endif /* INCLUDE_NETWORK_DATA_H_ */
