/*
 * tiva_emac.cpp
 *
 * Ethernet MAC class
 *
 *  Created on: Jun 15, 2016
 *      Author: yli
 */


#include <stdint.h>
#include <stdbool.h>
#include "B4090403_X7.h"
#include <inc/hw_memmap.h>
#include <inc/hw_ints.h>
#include <inc/hw_flash.h>
#include <driverlib/flash.h>
#include <driverlib/gpio.h>
#include <driverlib/pin_map.h>
#include <driverlib/sysctl.h>
#include <ti/drivers/EMAC.h>
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/family/arm/m3/Hwi.h>
#include <ti/drivers/emac/EMACSnow.h>
#include <inc/hw_emac.h>
#include <driverlib/EMAC.h>
#include <stdio.h>
#include "tiva_emac.h"
#include "EMACSnow.h"

#define NUM_TIVA_EMACS          1

// Combined valid configuration flags.
#define VALID_CONFIG_FLAGS      (EMAC_CONFIG_USE_MACADDR1 |                   \
                                 EMAC_CONFIG_SA_INSERT |                      \
                                 EMAC_CONFIG_SA_REPLACE |                     \
                                 EMAC_CONFIG_2K_PACKETS |                     \
                                 EMAC_CONFIG_STRIP_CRC |                      \
                                 EMAC_CONFIG_JABBER_DISABLE |                 \
                                 EMAC_CONFIG_JUMBO_ENABLE |                   \
                                 EMAC_CONFIG_IF_GAP_MASK |                    \
                                 EMAC_CONFIG_CS_DISABLE |                     \
                                 EMAC_CONFIG_100MBPS |                        \
                                 EMAC_CONFIG_RX_OWN_DISABLE |                 \
                                 EMAC_CONFIG_LOOPBACK |                       \
                                 EMAC_CONFIG_FULL_DUPLEX |                    \
                                 EMAC_CONFIG_CHECKSUM_OFFLOAD |               \
                                 EMAC_CONFIG_RETRY_DISABLE |                  \
                                 EMAC_CONFIG_AUTO_CRC_STRIPPING |             \
                                 EMAC_CONFIG_BO_MASK |                        \
                                 EMAC_CONFIG_DEFERRAL_CHK_ENABLE |            \
                                 EMAC_CONFIG_PREAMBLE_MASK)

// *******************************************************************
// Structures required by TI NDK - ported from DK_TM4C129X.c example
// *******************************************************************
EMACSnow_Object emacObjects[NUM_TIVA_EMACS];         // EMAC objects

/*
 *  Required by the Networking Stack (NDK). This array must be NULL terminated.
 *  This can be removed if NDK is not used.
 *  Double curly braces are needed to avoid GCC bug #944572
 *  https://bugs.launchpad.net/gcc-linaro/+bug/944572
 */


int EMACSnow_NIMUInit(STKEVENT_Handle hEvent);

NIMU_DEVICE_TABLE_ENTRY  NIMUDeviceTable[2] = {{EMACSnow_NIMUInit}, {NULL}};
const EMACSnow_HWAttrs emacHWAttrs[NUM_TIVA_EMACS] = {
    {EMAC0_BASE, INT_EMAC0, ~0 /* Interrupt priority */, TIVAEMAC::m_mac_address}
};
EMAC_Config EMAC_config[] = {
    {
        &EMACSnow_fxnTable,
        &emacObjects[0],
        &emacHWAttrs[0]
    },
    {NULL, NULL, NULL}
};


// *******************************************************************
// Start TIVAEMAC class
// *******************************************************************
bool TIVAEMAC::m_is_initialized = false;
uint8_t TIVAEMAC::m_mac_address[MAC_ADDRESS_SIZE] = {0x38, 0x3A, 0x21, 0xA0, 0x00, 0x01};


TIVAEMAC::TIVAEMAC()
{

}


// MAC address needs to be set here - this value is contained in emacHWAttrs which gets used in EMAC_init
void TIVAEMAC::Init()
{
    if(m_is_initialized == false)
    {
        /* Get the MAC address */
        m_mac_address[5] = 99;
        m_mac_address[4] = 0;
        m_mac_address[3] = 160;
        m_mac_address[2] = 33;
        m_mac_address[1] = 58;
        m_mac_address[0] = 56;

        SysCtlPeripheralEnable(ENET_LED0_GPIO_SYSCTL);
        SysCtlPeripheralEnable(ENET_LED2_GPIO_SYSCTL);
        GPIOPinConfigure(ENET_LED0);
        GPIOPinConfigure(ENET_LED2);
        GPIOPinTypeEthernetLED(ENET_LED0_GPIO_PORT, ENET_LED0_GPIO_PIN);
        GPIOPinTypeEthernetLED(ENET_LED2_GPIO_PORT, ENET_LED2_GPIO_PIN);

        SysCtlPeripheralEnable(SYSCTL_PERIPH_EMAC0);
        SysCtlPeripheralEnable(SYSCTL_PERIPH_EPHY0);

        PrintPHYRegs();

        /* Once EMAC_init is called, EMAC_config cannot be changed */
        EMAC_init();

        m_is_initialized = true;
    }
}

void TIVAEMAC::PrintPHYRegs()
{
    uint8_t ui8PHYAddr = 0;
    uint16_t phy_reg = EMACPHYRead(EMAC0_BASE, ui8PHYAddr, EPHY_BMCR);
    printf("EPHY_BMCR = 0x%x\n", phy_reg);
    phy_reg = EMACPHYRead(EMAC0_BASE, ui8PHYAddr, EPHY_BMSR);
    printf("BMSR = 0x%x\n", phy_reg);
    phy_reg = EMACPHYRead(EMAC0_BASE, ui8PHYAddr, EPHY_ANA);
    printf("EPHY_ANA = 0x%x\n", phy_reg);
    phy_reg = EMACPHYRead(EMAC0_BASE, ui8PHYAddr, EPHY_ANLPA);
    printf("EPHY_ANLPA = 0x%x\n", phy_reg);
    phy_reg = EMACPHYRead(EMAC0_BASE, ui8PHYAddr, EPHY_STS);
    printf("EPHY_STS = 0x%x\n", phy_reg);
}

void TIVAEMAC::Force100Mbps()
{
    uint32_t emac_cfg = 0;
    uint32_t emac_pc = 0;

    //        uint32_t emac_mode = 0;
//        uint32_t emac_max_frm_sz = 0;
//        EMACConfigGet(0x400EC000, &emac_cfg, &emac_mode, &emac_max_frm_sz);
    emac_cfg = (HWREG(0x400EC000 + EMAC_O_CFG) &
                    (VALID_CONFIG_FLAGS | EMAC_CONFIG_TX_ENABLED |
                     EMAC_CONFIG_RX_ENABLED));

    emac_cfg |= EMAC_CONFIG_100MBPS;
    HWREG(0x400EC000 + EMAC_O_CFG) = emac_cfg;

    emac_pc = HWREG(0x400EC000 + EMAC_O_PC);
    emac_pc = (emac_pc & (~EMAC_PC_ANEN))| EMAC_PC_ANMODE_100FD;
    //HWREG(0x400EC000 + EMAC_O_PC) = emac_pc;

    EMACPHYConfigSet(0x400EC000, emac_pc);
//        EMACConfigSet(0x400EC000, emac_cfg, emac_mode, emac_max_frm_sz);

}

bool TIVAEMAC::isLinkActive()
{
    return(EMACSnow_isLinkUp(0));
    //return(0);
}


/* Used to check status for initialization */
static int EMAC_count = -1;

/*
 *  ======== EMAC_init ========
 */
void EMAC_init(void)
{
    /*
     *  Allow only the first initialization to do anything.
     *  The next ones are nops.
     */
    if (EMAC_count >= 0) {
        return;
    }

    /* Call each driver's init function */
    for (EMAC_count = 0; EMAC_config[EMAC_count].fxnTablePtr != NULL;
         EMAC_count++) {
        EMAC_config[EMAC_count].fxnTablePtr->emacInit(EMAC_count);
    }

    return;
}

extern "C" void TIVAEMAC_Init()
{
    TIVAEMAC::Init();
}
