/*
 * TivaTimer.cpp
 *
 *  Created on: Sep 24, 2015
 *      Author: yli
 */

#include "tiva_timer.h"
#include "driverlib\timer.h"
#include "driverlib\interrupt.h"
#include "driverlib\sysctl.h"

TivaTimer::TivaTimer() {}

void TivaTimer::Init()
{
   // Enable Clock for Timer peripheral.
   SysCtlPeripheralEnable(TIVA_TIMER_PERIPH);

   // Ensure Timer is disabled before configuring it
   HWREG(TIVA_TIMER_BASE + TIMER_CTRL) &= ~(TIMER_CTRL_BOTH &
                                    (TIMER_ENBL_TIMER_A | TIMER_ENBL_TIMER_B));

   // TIMER_CLOCK_SYSTEM is 120 MHz
   HWREG(TIVA_TIMER_BASE + TIMER_CLOCK_CFG) = TIMER_CLK_CFG_SEL_SYS_CLK;

   // Configure Timer as a single periodic count up
   HWREG(TIVA_TIMER_BASE + TIMER_CFG) = TIMER_SEL_32_BIT_TIMER;

   // Configure TimerA and TimerB modes
   HWREG(TIVA_TIMER_BASE + TIMER_A_MODE) = (TIMER_TA_MODE_MATCH_IE |
       TIMER_TA_MODE_INT_DISABLE | TIMER_TA_MODE_CNT_UP | TIMER_TA_MODE_PERIODIC);
   HWREG(TIVA_TIMER_BASE + TIMER_B_MODE) =
       (TIMER_TA_MODE_INT_DISABLE | TIMER_TB_MODE_CNT_UP | TIMER_TB_MODE_PERIODIC);

   // Timer Match Set
   HWREG(TIVA_TIMER_BASE + TIMER_A_ILOAD) = 0xffffffff;
   HWREG(TIVA_TIMER_BASE + TIMER_B_ILOAD) = 0xffffffff;

   // Enalbe Timer
   HWREG(TIVA_TIMER_BASE + TIMER_CTRL) |= TIMER_BOTH & (TIMER_CTL_TAEN | TIMER_CTL_TBEN);
}


// Returns the value of the 32-bit Timer
uint32_t TivaTimer::get_count()
{
	uint32_t timerVal = HWREG(TIVA_TIMER_BASE + TIMER_A_CNT);

    return(timerVal);
}


// This returns the time in increments of approx 1.0667 microseconds
uint32_t TivaTimer::GetTime_us()
{
	uint32_t current_time = get_count();

	uint32_t retval = current_time >> 7;

	return(retval);
}


uint32_t TivaTimer::CalcDeltaTime(uint32_t time2, uint32_t time1)
{
	uint32_t delta_time;

	delta_time = time2 - time1;

	return(delta_time);
}


uint32_t TivaTimer::CalcDeltaTime(uint32_t time1)
{
   uint32_t time2;
   uint32_t delta_time;

   time2 = HWREG(TIVA_TIMER_BASE + TIMER_A_CNT);
   delta_time = time2 - time1;

   return(delta_time);
}


void TivaTimer::Delay(uint32_t time1)
{
   uint32_t start_time;
   uint32_t delta_time;

   start_time = HWREG(TIVA_TIMER_BASE + TIMER_A_CNT);
   // Check if time has not rolled over
   do{
       delta_time = CalcDeltaTime(start_time);
   }while(time1 > delta_time);
}

extern "C"
uint32_t TivaTimer_get_count()
{
    return(TivaTimer::get_count());
}

extern "C"
uint32_t TivaTimer_CalcDeltaTime(uint32_t start_time)
{
    return(TivaTimer::CalcDeltaTime(start_time));
}

extern "C"
void TivaTimer_Init()
{
    TivaTimer::Init();
}
