/*
 * TivaTimer.h
 *
 *  Created on: Sep 24, 2015
 *      Author: yli
 */

#ifndef TIVATIMER_TIVATIMER_H_
#define TIVATIMER_TIVATIMER_H_

#include <stdint.h>
#include <stdbool.h>
#include "B4090403_X7.h"


// Timer 3 is clocked by the 120MHz system clock.
// !!! WARNING - timer only has range of 35s at which point it rolls over to 0 !!!
#define TIVA_TIMER3_TIME_1us        TIVA_T3_TIME_1us
#define TIVA_TIMER3_TIME_1ms        TIVA_T3_TIME_1ms
#define TIVA_TIMER3_TIME_1s	        TIVA_T3_TIME_1s

// Timer is 32-bit
#define TIVA_TIMER_MAX_TIME         TIVA_T3_TIMER_MAX_TIME

#ifdef __cplusplus
class TivaTimer {
public:
	static void Init();
	static uint32_t get_count();
	static uint32_t GetTime_us();
	static uint32_t CalcDeltaTime(uint32_t time2, uint32_t time1);
	static uint32_t CalcDeltaTime(uint32_t time1);
	static void SetInterrupt(uint32_t elapsed_time, void (*p_int_handler)());
	static void Delay(uint32_t time1);

private:
	TivaTimer();
};
#else
uint32_t TivaTimer_get_count();
uint32_t TivaTimer_CalcDeltaTime(uint32_t start_time);
#endif

#endif /* TIVATIMER_TIVATIMER_H_ */

