/*
 * B4090403_X7.h
 *
 *  Created on: Oct 9, 2015
 *      Author: yli
 */

#ifndef HEADER_B4090403_X7_H_
#define HEADER_B4090403_X7_H_

#include <stdint.h>
#include <stdbool.h>

#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "inc/hw_timer.h"
#include "inc/hw_ints.h"
#include "inc/hw_i2c.h"
#include "inc/hw_ssi.h"
#include "inc/hw_ccm.h"

#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/pwm.h"
#include "driverlib/ssi.h"

#define TARGET_CLOCK_FREQ_HZ  120000000u

// Timer 3 is clocked by the 120MHz system clock.
#define TIVA_T3_TIME_1us        (TARGET_CLOCK_FREQ_HZ/1000000)
#define TIVA_T3_TIME_1ms        (TARGET_CLOCK_FREQ_HZ/1000)
#define TIVA_T3_TIME_1s         TARGET_CLOCK_FREQ_HZ

// Timer is 32-bit
#define TIVA_T3_TIMER_MAX_TIME  0xFFFFFFFF

// TIVA Timer Config
#define TIVA_TIMER_BASE                      TIMER3_BASE
#define TIVA_TIMER_PERIPH                    SYSCTL_PERIPH_TIMER3

// General Timer Config
#define TIMER_CTRL                           TIMER_O_CTL
   #define TIMER_CTRL_BOTH                   TIMER_BOTH
   #define TIMER_ENBL_TIMER_A                TIMER_CTL_TAEN
   #define TIMER_ENBL_TIMER_B                TIMER_CTL_TBEN

#define TIMER_CLOCK_CFG                      TIMER_O_CC
   #define TIMER_CLK_CFG_SEL_SYS_CLK         TIMER_CLOCK_SYSTEM

#define TIMER_CFG                            TIMER_O_CFG
   #define TIMER_SEL_32_BIT_TIMER            TIMER_CFG_32_BIT_TIMER

#define TIMER_A_MODE                         TIMER_O_TAMR
   #define TIMER_TA_MODE_INT_DISABLE         TIMER_TAMR_TACINTD
   #define TIMER_TA_MODE_CNT_UP              TIMER_TAMR_TACDIR
   #define TIMER_TA_MODE_PERIODIC            TIMER_TAMR_TAMR_PERIOD
   #define TIMER_TA_MODE_MATCH_IE            TIMER_TAMR_TAMIE

#define TIMER_B_MODE                         TIMER_O_TBMR
   #define TIMER_TB_MODE_INT_DISABLE         TIMER_TBMR_TBCINTD
   #define TIMER_TB_MODE_CNT_UP              TIMER_TBMR_TBCDIR
   #define TIMER_TB_MODE_PERIODIC            TIMER_TBMR_TBMR_PERIOD

#define TIMER_A_ILOAD                  TIMER_O_TAILR
#define TIMER_B_ILOAD                  TIMER_O_TBILR

#define TIMER_A_CNT                          TIMER_O_TAR


//======== GPIO Config ========
// Ethernet pins
#define ENET_LED0_GPIO_SYSCTL           SYSCTL_PERIPH_GPIOF     //PF0
#define ENET_LED2_GPIO_SYSCTL           SYSCTL_PERIPH_GPIOF     //PF1
#define ENET_LED0                       GPIO_PF0_EN0LED0
#define ENET_LED2                       GPIO_PF1_EN0LED2
#define ENET_LED0_GPIO_PORT             GPIO_PORTF_BASE
#define ENET_LED0_GPIO_PIN              GPIO_PIN_0
#define ENET_LED2_GPIO_PORT             GPIO_PORTF_BASE
#define ENET_LED2_GPIO_PIN              GPIO_PIN_1

#endif
