/*
 * network_interface.h
 *
 *  Created on: Jun 23, 2016
 *      Author: yli
 */

#ifndef NDKLAUNCHPAD_INCLUDE_NETWORK_INTERFACE_H_
#define NDKLAUNCHPAD_INCLUDE_NETWORK_INTERFACE_H_

#include <stdint.h>
#include "network_data.h"
#include "Ethernet.h"

#define UDP_PORT_NUM        10065
#define TCP_PORT_NUM        10070
#define MAX_TCP_PORT_NUM    (TCP_PORT_NUM + 16)
#define MAX_UDP_MSG_SIZE        128
#define NETWORK_RCV_BUF_SZ      MAX_MSG_SIZE

class NetworkInterface
{
public:
    //static bool SetInterface(Interface_t net_interface);
    static void Init();
    static void MaintainLink();
    static void SendReceive();
    static uint32_t GetIPAddr();

    // sends to all TCP clients
    static bool QueueToSend(uint8_t *p_data, uint32_t size, Interface_t interface);

    // generic send
    static bool QueueToSend(NetworkData *p_net_data, Interface_t interface);

    static void Reply(NetworkData *p_net_data);
    static uint8_t get_num_ports_avail(uint16_t *p_port_num, Interface_t interface);
    static void OnEthernetDisconnect(uint32_t dummy_val);
    static void HandleIPAddrAssignedEvent(Interface_t interface);
    static void NotifySocketConnected(EthTCPSocketData_t *p_socket_data);

private:
    NetworkInterface();
    static bool OpenSockets();

    //static Interface_t m_interface;
    static uint16_t m_tcp_port_num;
    static uint8_t m_network_rcv_buf[NETWORK_RCV_BUF_SZ];
    static bool m_are_ethernet_sockets_opened;
};


#endif /* NDKLAUNCHPAD_INCLUDE_NETWORK_INTERFACE_H_ */

