/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "het.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
uint8_t PWM1_FLAG = 0;
uint8_t PWM2_FLAG = 0;
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    hetInit();
    _enable_IRQ();

    pwmEnableNotification(hetREG1,pwm1,pwmEND_OF_PERIOD);
    pwmEnableNotification(hetREG1,pwm2,pwmEND_OF_PERIOD);

    pwmStart(hetRAM1,pwm1);
    pwmStart(hetRAM1,pwm2);

    while(1)
    {
        if(PWM1_FLAG == 0xFF)
        {
            PWM1_FLAG = 0;
        }
        else if(PWM2_FLAG == 0xFF)
        {
            PWM2_FLAG = 0;
        }
        else
        {
            ;
        }
    }
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
void pwmNotification(hetBASE_t * hetREG,uint32 pwm, uint32 notification)
{
    if((hetREG == hetREG1) && (pwm == pwm1) && (notification == pwmEND_OF_PERIOD))
    {
        PWM1_FLAG = 0xFF;
    }
    else if((hetREG == hetREG1) && (pwm == pwm2) && (notification == pwmEND_OF_PERIOD))
    {
        PWM2_FLAG = 0xFF;
    }
}
/* USER CODE END */
