/*
 * commands.c
 *
 *  Created on: Sep 13, 2018
 *      Author: robert.applebee
 */

#include "commands.h"
#include "platform.h"
#include "poe.h"

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>



int HandleGetDataStreamFrame(char** tokens, int nTokens, char* send_buffer)
{
    int nArgs = nTokens - 1;
    char packet[] = "---------------- --";
    char buff[64];


    if (nArgs != 0)
    {
        sprintf(send_buffer, NAK_BadArgCount, nArgs, 0);
        return CMDFAILURE;
    }


    updateUdpPacket(packet);
    sprintf(buff, "%s %04X %s", GetPodId(), g_usSeq, packet);

    g_usSeq++;

    sprintf(send_buffer, "%s", buff);
    return CMDSUCCESS;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


CommandHandler commandHandlers[] =
{
    { "idn?",               HandleIdAndVersion },
    { "rst",                HandleReset },
    { "switch?",            HandleSwitch },
    { "getvolt?",           Handle24V },

    { "ioconfig",           HandleSetIoConfig },
    { "ioconfig?",          HandleGetIoConfig },

    { "outputmode",         HandleSetOutputMode },
    { "outputmode?",        HandleGetOutputMode },

    { "inputimpedance",     HandleSetInputImpedance },
    { "inputimpedance?",    HandleGetInputImpedance },

    { "digitaloutput",      HandleSetDigitalOutput },
    { "digitaloutput?",     HandleGetDigitalOutput },
    { "digitalanalog?",     HandleGetDigitalAnalog },

    { "digitaloutputall",   HandleSetDigitalOutputAll },
    { "digitaloutputall?",  HandleGetDigitalOutputAll },
    { "digitalanalogall?",  HandleGetDigitalAnalogAll },

    { "analogthresholds",   HandleSetAnalogThresholds },
    { "analogthresholds?",  HandleGetAnalogThresholds },

    { "analogoutput",       HandleSetAnalogOutput },
    { "analogoutput?",      HandleGetAnalogOutput },

    { "analogoutputall",    HandleSetAnalogOutputAll },
    { "analogoutputall?",   HandleGetAnalogOutputAll },

    { "analoginput?",       HandleGetAnalogInput },
    { "analoginputall?",    HandleGetAnalogInputAll },

    { "analogfiltercoef",   HandleSetAnalogFilterCoef },
    { "analogfiltercoef?",  HandleGetAnalogFilterCoef },

    { "datastreamdelay",    HandleSetDataStreamDelay },
    { "datastreamdelay?",   HandleGetDataStreamDelay },
    { "*?",                 HandleGetDataStreamFrame },
};

const int NUM_COMMANDS = sizeof(commandHandlers) / sizeof(CommandHandler);



