/*
 *  Copyright (C) 2021 Texas Instruments Incorporated
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Auto generated file
 */

#include "ti_drivers_open_close.h"
#include <kernel/dpl/DebugP.h>

void Drivers_open(void)
{
    Drivers_uartOpenLld();
}

void Drivers_close(void)
{
    Drivers_uartCloseLld();
}


/*
 * UART
 */
#include <drivers/uart/v0/lld/uart_lld.h>
UARTLLD_Object gUartObject[CONFIG_UART_NUM_LLD_INSTANCES];
UARTLLD_Handle gUartHandleLld[CONFIG_UART_NUM_LLD_INSTANCES];

/* UART Driver handles */
extern UARTLLD_InitObject gUartInitObject[CONFIG_UART_NUM_LLD_INSTANCES];


/* UART Driver handles */

void Drivers_uartOpenLld(void)
{
    int32_t status = UART_STATUS_SUCCESS;

    gUartHandleLld[CONFIG_UART0]             = &gUartObject[CONFIG_UART0];
    gUartHandleLld[CONFIG_UART0]->state      = UART_STATE_RESET;
    gUartHandleLld[CONFIG_UART0]->baseAddr   = CSL_MCU_UART0_BASE;
    gUartHandleLld[CONFIG_UART0]->hUartInit = &gUartInitObject[CONFIG_UART0];

    status += UART_lld_init(gUartHandleLld[CONFIG_UART0]);

    DebugP_assert(status == UART_STATUS_SUCCESS);
    return;

}

void Drivers_uartCloseLld(void)
{
    int32_t status = UART_STATUS_SUCCESS;

    status += UART_lld_deInit(gUartHandleLld[CONFIG_UART0]);

    DebugP_assert(status == UART_STATUS_SUCCESS);
    return;
}

