/** @file HL_sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
#include "HL_sys_dma.h"
#include "HL_sci.h"
#include "stdio.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
#define RX_DMA_TEST 1
#define TX_DMA_TEST 0

#define SIZE 4

/*Rx data buffer */
#if (RX_DMA_TEST)
uint8_t RX_DATA[SIZE] = {0};
#endif
#if (TX_DMA_TEST)
uint8_t TX_DATA[SIZE] = {0};
#endif

/* Addresses of SCI 8-bit TX/Rx data */
#define SCI1_TX_ADDR ((uint32_t)(&(sciREG1->TD)) + 3)
#define SCI1_RX_ADDR ((uint32_t)(&(sciREG1->RD)) + 3)

#define DMA_SCI1_TX  DMA_REQ29
#define DMA_SCI1_RX  DMA_REQ28

#define SCI_TX_DMA      (1<<16)
#define SCI_SET_RX_DMA      (1<<17)
#define SCI_SET_RX_DMA_ALL  (1<<18)
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
#if (RX_DMA_TEST)
    uint32 sciRxData;
    g_dmaCTRL g_dmaRxCTRLPKT;
#endif
#if (TX_DMA_TEST)
    uint32 sciTxData;
    g_dmaCTRL g_dmaTxCTRLPKT;
#endif

    /*Initialize SCI*/
    sciInit();

    while (((sciREG1->FLR & SCI_TX_INT) == 0U) || ((sciREG1->FLR & 0x4) == 0x4))
    {
    } /* Wait */

#if (RX_DMA_TEST)
    /*Assign DMA request SCI1 receive to Channel 1*/
    //dmaReqAssign(DMA_CH1, DMA_SCI1_RX);

    sciRxData = SCI1_RX_ADDR;

    /*Configure control packet for Channel 1*/
    g_dmaRxCTRLPKT.SADD      = sciRxData;            /* source address             */
    g_dmaRxCTRLPKT.DADD      = (uint32_t)RX_DATA;    /* destination  addr ss       */
    g_dmaRxCTRLPKT.CHCTRL    = 0;                    /* channel control            */
    g_dmaRxCTRLPKT.FRCNT    = SIZE;                  /* frame count                */
    g_dmaRxCTRLPKT.ELCNT     = 1;                    /* element count              */
    g_dmaRxCTRLPKT.ELDOFFSET = 0;                    /* element destination offset */
    g_dmaRxCTRLPKT.ELSOFFSET = 0;                    /* element destination offset */
    g_dmaRxCTRLPKT.FRDOFFSET = 0;                    /* frame destination offset   */
    g_dmaRxCTRLPKT.FRSOFFSET = 0;                    /* frame destination offset   */
    g_dmaRxCTRLPKT.PORTASGN  = PORTB_READ_PORTA_WRITE;
    g_dmaRxCTRLPKT.RDSIZE    = ACCESS_8_BIT;         /* read size                  */
    g_dmaRxCTRLPKT.WRSIZE    = ACCESS_8_BIT;         /* write size                 */
    g_dmaRxCTRLPKT.TTYPE     = FRAME_TRANSFER;       /* transfer type              */
    g_dmaRxCTRLPKT.ADDMODERD = ADDR_FIXED;           /* address mode read          */
    g_dmaRxCTRLPKT.ADDMODEWR = ADDR_INC1;            /* address mode write         */
    g_dmaRxCTRLPKT.AUTOINIT  = AUTOINIT_OFF;         /* autoinit                   */

    /*Set control packet for channel 0 and 1*/
    dmaSetCtrlPacket(DMA_CH28, g_dmaRxCTRLPKT);

    /*Set dma channel 0 and 1 to trigger on hardware request*/
    dmaSetChEnable(DMA_CH28, DMA_HW);
#endif

#if (TX_DMA_TEST)
    uint32_t    i;
    for(i=0; i<SIZE; i++)
    {
        TX_DATA[i] = i;
    }

    /*Assign DMA request SCI1 receive to Channel 1*/
    //dmaReqAssign(DMA_CH1, DMA_SCI1_RX);

    sciTxData = SCI1_TX_ADDR;

    /*Configure control packet for Channel 1*/
    g_dmaTxCTRLPKT.SADD      = (uint32_t)TX_DATA;            /* source address             */
    g_dmaTxCTRLPKT.DADD      = sciTxData;    /* destination  addr ss       */
    g_dmaTxCTRLPKT.CHCTRL    = 0;                    /* channel control            */
    g_dmaTxCTRLPKT.FRCNT    = SIZE;                  /* frame count                */
    g_dmaTxCTRLPKT.ELCNT     = 1;                    /* element count              */
    g_dmaTxCTRLPKT.ELDOFFSET = 0;                    /* element destination offset */
    g_dmaTxCTRLPKT.ELSOFFSET = 0;                    /* element destination offset */
    g_dmaTxCTRLPKT.FRDOFFSET = 0;                    /* frame destination offset   */
    g_dmaTxCTRLPKT.FRSOFFSET = 0;                    /* frame destination offset   */
    g_dmaTxCTRLPKT.PORTASGN  = PORTA_READ_PORTB_WRITE;
    g_dmaTxCTRLPKT.RDSIZE    = ACCESS_8_BIT;         /* read size                  */
    g_dmaTxCTRLPKT.WRSIZE    = ACCESS_8_BIT;         /* write size                 */
    g_dmaTxCTRLPKT.TTYPE     = FRAME_TRANSFER;       /* transfer type              */
    g_dmaTxCTRLPKT.ADDMODERD = ADDR_INC1;           /* address mode read          */
    g_dmaTxCTRLPKT.ADDMODEWR = ADDR_FIXED;            /* address mode write         */
    g_dmaTxCTRLPKT.AUTOINIT  = AUTOINIT_OFF;         /* autoinit                   */

    /*Set control packet for channel 0 and 1*/
    dmaSetCtrlPacket(DMA_CH29, g_dmaTxCTRLPKT);

    /*Set dma channel 0 and 1 to trigger on hardware request*/
    dmaSetChEnable(DMA_CH29, DMA_HW);
#endif

    /*Enable DMA*/
    dmaEnable();

#if (RX_DMA_TEST)
    sciREG1->SETINT |=  SCI_SET_RX_DMA | SCI_SET_RX_DMA_ALL;
#endif

#if (TX_DMA_TEST)
    sciREG1->SETINT |=  SCI_TX_DMA;
#endif

    while(1)
    {
        ;
    }

/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
/* USER CODE END */
