/** @file HL_sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
#include "HL_sci.h"
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
uint8 rx_idx;
uint8 rx_buf[ 32 ];
uint8 tx_buf[ 32 ];
uint8 ch;
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */

    memset( &rx_buf, 0x00, sizeof( rx_buf ) );
    rx_idx = 0;

    memset( &tx_buf, 0xAA, sizeof( tx_buf ) - 1 );
    tx_buf[ sizeof( tx_buf ) - 1 ] = 0x0A;

    _enable_interrupt_();

    sciInit();
    sciEnableLoopback( sciREG3, Digital_Lbk );
    while((sciREG3->FLR & SCI_IDLE) == SCI_IDLE);

    sciReceive( sciREG3, 1, ( uint8 * ) &ch );

    sciSend( sciREG3, 32, ( uint8 * ) &tx_buf[ 0 ] );

    while ( 1 );
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
void sciNotification( sciBASE_t *sci, uint32 flags )
{
    if(flags ==  SCI_RX_INT)
    {
        if ( ch == 0x0A )
        {
            rx_idx = 0;
        }
        else
        {
        /* Store character in corresponding SCI Rx Buffer and post increment array index */
            rx_buf[ rx_idx ]= ch;
            rx_idx++;
        }
        sciReceive( sci, 1, ( uint8 * ) &ch );
    }
}
/* USER CODE END */
