/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "sys_core.h"
#include "sys_dma.h"
#include "spi.h"

/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
#define D_SIZE        (8*3)

#define SPI_MASTER    spiREG1

#define MASTER_SPI_TX_ADDR ((uint32_t)(&(spiREG1->DAT1)))

#define DMA_REQ1 1

uint32 tx_data[D_SIZE] = {0x10FE0010, 0x10FE0000, 0x00FE0000, 0x10FE0011, 0x10FE0000, 0x00FE0000, 0x10FE0012, 0x10FE0000, 0x00FE0000, 0x10FE0013, 0x10FE0000, 0x00FE0000, 0x10FE0014, 0x10FE0000, 0x00FE0000, 0x10FE0015, 0x10FE0000, 0x00FE0000, 0x10FE0016, 0x10FE0000, 0x00FE0000, 0x10FE0017, 0x10FE0000, 0x00FE0000};

unsigned int MASTER_SPI_DMA_FTCFlag  = 0;
unsigned int MASTER_SPI_DMA_HBCFlag  = 0;
unsigned int MASTER_SPI_DMA_BTCFlag  = 0;

g_dmaCTRL g_dmaCTRLPKT_TX;

static void dmaConfigCtrlTxPacket (uint32 sadd,  uint32 dadd, uint16 ElmntCnt, uint16 FrameCnt);
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    spiInit();

    dmaEnable();

    dmaReqAssign(DMA_CH1, DMA_REQ1);    //SPI1 TX

    /* - setting dma control packets */
    dmaConfigCtrlTxPacket((uint32)tx_data, MASTER_SPI_TX_ADDR, 1, D_SIZE); //TBC
    dmaSetCtrlPacket(DMA_CH1, g_dmaCTRLPKT_TX);

    dmaSetChEnable(DMA_CH1, DMA_HW);

    SPI_MASTER->GCR1 |= (0x1 << 24);  //Enable SPI
    SPI_MASTER->INT0 |= (0x1 << 16);  //SPI_DMAREQ; Enable DMA REQ only after setting the SPIEN bit to 1.

    while(1);
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */

void dmaGroupANotification(dmaInterrupt_t inttype, uint32 channel)
{
    if (inttype == FTC)
    {
        MASTER_SPI_DMA_FTCFlag = 1;
    }
    else if (inttype == HBC)
    {
        MASTER_SPI_DMA_HBCFlag = 1;
    }
    else if (inttype == BTC)
    {
        MASTER_SPI_DMA_BTCFlag = 1;
    }
}

static void dmaConfigCtrlTxPacket (uint32 sadd, uint32 dadd, uint16 ElmntCnt, uint16 FrameCnt)
{
    /* - configuring dma control packets   */
    g_dmaCTRLPKT_TX.SADD      = sadd;
    g_dmaCTRLPKT_TX.DADD      = dadd;
    g_dmaCTRLPKT_TX.CHCTRL    = 0;
    g_dmaCTRLPKT_TX.FRCNT     = FrameCnt;
    g_dmaCTRLPKT_TX.ELCNT     = ElmntCnt;
    g_dmaCTRLPKT_TX.ELDOFFSET = 0;
    g_dmaCTRLPKT_TX.ELSOFFSET = 0;
    g_dmaCTRLPKT_TX.FRDOFFSET = 0;
    g_dmaCTRLPKT_TX.FRSOFFSET = 0;
    g_dmaCTRLPKT_TX.PORTASGN  = 4; // PORTA_READ_PORTB_WRITE;
    g_dmaCTRLPKT_TX.RDSIZE    = ACCESS_32_BIT;
    g_dmaCTRLPKT_TX.WRSIZE    = ACCESS_32_BIT;
    g_dmaCTRLPKT_TX.TTYPE     = FRAME_TRANSFER;
    g_dmaCTRLPKT_TX.ADDMODERD = ADDR_INC1;
    g_dmaCTRLPKT_TX.ADDMODEWR = ADDR_FIXED;
    g_dmaCTRLPKT_TX.AUTOINIT  = AUTOINIT_OFF;
}
/* USER CODE END */
