/*
 *  Copyright (C) 2021 Texas Instruments Incorporated
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Auto generated file
 */

#include "ti_drivers_config.h"


#include "ti_drivers_open_close.h"
#include <drivers/mcspi/v0/lld/mcspi_lld.h>
#include <kernel/dpl/ClockP.h>

/*
 * MCSPI
 */
extern MCSPILLD_Object gMcspiObject[CONFIG_MCSPI_NUM_INSTANCES];
extern MCSPILLD_Handle gMcspiHandle[CONFIG_MCSPI_NUM_INSTANCES];

uint32_t gMcspiNumCh[1] =
{
    CONFIG_MCSPI0_NUM_CH,
};

uint32_t gMcspiDmaConfigNum = CONFIG_MCSPI_NUM_DMA_INSTANCES;

/*   MCSPI Transfer Callback Function    */
void MCSPI_lld_transferCallback(void *args, uint32_t transferStatus);
/* MCSPI Error Callback Function */
void MCSPI_lld_errorCallback(void *args, uint32_t transferStatus);

/* MCSPI Driver Channel Configurations */
MCSPI_ChConfig gConfigMcspi0ChCfg[CONFIG_MCSPI0_NUM_CH] =
{
    {
        .chNum              = MCSPI_CHANNEL_0,
        .frameFormat        = MCSPI_FF_POL0_PHA0,
        .bitRate            = 100000,
        .csPolarity         = MCSPI_CS_POL_LOW,
        .trMode             = MCSPI_TR_MODE_TX_RX,
        .inputSelect        = MCSPI_IS_D0,
        .dpe0               = MCSPI_DPE_DISABLE,
        .dpe1               = MCSPI_DPE_ENABLE,
        .slvCsSelect        = MCSPI_SLV_CS_SELECT_0,
        .startBitEnable     = FALSE,
        .startBitPolarity   = MCSPI_SB_POL_LOW,
        .turboEnable        = FALSE,
        .csIdleTime         = MCSPI_TCS0_0_CLK,
        .defaultTxData      = 0x0U,
        .txFifoTrigLvl      = 16U,
        .rxFifoTrigLvl      = 16U,
    },
};

uint32_t gMcspiConfigNum = CONFIG_MCSPI_NUM_INSTANCES;



/* MCSPI init objects */
MCSPILLD_InitObject gMcspiInitObject[CONFIG_MCSPI_NUM_INSTANCES] =
{
    {
        .inputClkFreq                = 50000000,
        .intrNum                     = CSLR_R5FSS0_CORE0_INTR_MCSPI0_INTR,
        .operMode                    = MCSPI_OPER_MODE_INTERRUPT,
        .intrPriority                = 4U,
        .chMode                      = MCSPI_CH_MODE_SINGLE,
        .pinMode                     = MCSPI_PINMODE_4PIN,
        .initDelay                   = MCSPI_INITDLY_0,
        .multiWordAccess             = FALSE,
        .msMode                      = MCSPI_MS_MODE_PERIPHERAL,
        .chEnabled                   = {TRUE, FALSE, FALSE, FALSE},
        .mcspiDmaHandle              = NULL,
        .chObj[0].chCfg              = &gConfigMcspi0ChCfg[0],
        .chObj[0].dmaChCfg           = NULL,
        .chObj[0].dmaChConfigNum     = 0,
        .clockP_get                  = ClockP_getTicks,
        .transferCallbackFxn         = MCSPI_lld_transferCallback,
        .errorCallbackFxn            = MCSPI_lld_errorCallback,
    },
};

MCSPI_ChConfig *gConfigMcspiChCfg[1] =
{
    gConfigMcspi0ChCfg,
};
/*
 * UART
 */

/* UART atrributes */
static UART_Attrs gUartAttrs[CONFIG_UART_NUM_INSTANCES] =
{
        {
            .baseAddr           = CSL_UART0_U_BASE,
            .inputClkFreq       = 48000000U,
        },
};
/* UART objects - initialized by the driver */
static UART_Object gUartObjects[CONFIG_UART_NUM_INSTANCES];
/* UART driver configuration */
UART_Config gUartConfig[CONFIG_UART_NUM_INSTANCES] =
{
        {
            &gUartAttrs[CONFIG_UART_CONSOLE],
            &gUartObjects[CONFIG_UART_CONSOLE],
        },
};

uint32_t gUartConfigNum = CONFIG_UART_NUM_INSTANCES;

#include <drivers/uart/v0/lld/dma/uart_dma.h>
UART_DmaHandle gUartDmaHandle[] =
{
};

uint32_t gUartDmaConfigNum = CONFIG_UART_NUM_DMA_INSTANCES;

void Drivers_uartInit(void)
{
    UART_init();
}

/*
 * MCU_LBIST
 */

uint32_t gMcuLbistTestStatus = 0U;

void SDL_lbist_selftest(void)
{
}

void Pinmux_init(void);
void PowerClock_init(void);
void PowerClock_deinit(void);
/*
 * Common Functions
 */
void System_init(void)
{
    /* DPL init sets up address transalation unit, on some CPUs this is needed
     * to access SCICLIENT services, hence this needs to happen first
     */
    Dpl_init();

    
    /* initialize PMU */
    CycleCounterP_init(SOC_getSelfCpuClk());

    PowerClock_init();
    /* Now we can do pinmux */
    Pinmux_init();
    /* finally we initialize all peripheral drivers */
    Drivers_uartInit();
}

void System_deinit(void)
{
    UART_deinit();
    PowerClock_deinit();

    Dpl_deinit();
}
