/*
 * bl_config.h
 *
 *  Created on: 2014-6-24
 *      Author: ZB
 */

#ifndef BL_CONFIG_H_
#define BL_CONFIG_H_

//*****************************************************************************
//
// The frequency (MHz) of the crystal used to clock the microcontroller.
//
// This defines the crystal frequency used by the microcontroller running the
// boot loader.
//
// Depends on: None
// Exclusive of: None
// Requires: None
//
//*****************************************************************************
#define CRYSTAL_FREQ            16             //MHz

#define SYS_CLK_FREQ            180           //MHz

//*****************************************************************************
//
// The starting address of the application.  This must be the start address of any flash sector
//  and can not be 0 (the first sector is
// boot loader).
//
// The flash image of the boot loader must not be larger than this value.
//
// Depends on: None
// Exclusive of: None
// Requires: None
//
//*****************************************************************************

#define APP_START_ADDRESS       0x00020000


//*****************************************************************************
//
// The size of a single, erasable page in the flash.  This must be a power
// of 2.  The default value of 32K bytes represents the page size for
// first 4 sectors of the internal flash on TMS570LS3x MCUs. From 5th sector,
// it becomes 128K bytes (0x20000)
//
// Depends on: None
// Exclusive of: None
// Requires: None
//
//*****************************************************************************
#define FLASH_BANK0_SIZE           0x00180000     /* 0 ~ 3rd sector */
#define FLASH_BANK1_SIZE           0x00180000     /* 0 ~ 3rd sector */
#define FLASH_SIZE                 0x00300000     /* bank0, from 4th sector to 14th sector */

#define MSG_DEBUG

#endif /* BL_CONFIG_H_ */
