/**
 *  \file   mdio.h
 *
 *  \brief  MDIO APIs and macros.
 *
 *   This file contains the driver API prototypes and macro definitions.
 */

/* (c) Texas Instruments 2009-2014, All rights reserved. */

#ifndef __MDIO_H__
#define __MDIO_H__

#include "sys_common.h"
#include "hw_mdio.h"

#ifdef __cplusplus
extern "C" {
#endif

/* MDIO input and output frequencies in Hz */
#define MDIO_FREQ_INPUT           32000000U
#define MDIO_FREQ_OUTPUT          1000000U
/*****************************************************************************/

/**
 *  @addtogroup EMACMDIO
 *  @{
 */
/*
** Prototypes for the APIs
*/
extern uint32_t MDIOPhyAliveStatusGet(uint32_t baseAddr);
extern uint32_t MDIOPhyLinkStatusGet(uint32_t baseAddr);
extern void MDIOInit(uint32_t baseAddr, uint32_t mdioInputFreq,
                     uint32_t mdioOutputFreq);
extern boolean MDIOPhyRegRead(uint32_t baseAddr, uint32_t phyAddr,
                                   uint32_t regNum, volatile uint16_t * dataPtr);
extern void MDIOPhyRegWrite(uint32_t baseAddr, uint32_t phyAddr,
                            uint32_t regNum, uint16_t RegVal);
extern void MDIOEnable(uint32_t baseAddr);
extern void MDIODisable(uint32_t baseAddr);

#ifdef __cplusplus
}
#endif

/**@}*/
#endif /* __MDIO_H__ */
