/** @file reg_sci.h
*   @brief SCI Register Layer Header File
*   @date 24.Feb.2014
*   @version 03.08.01
*   
*   This file contains:
*   - Definitions
*   - Types
*   - Interface Prototypes
*   .
*   which are relevant for the SCI driver.
*/

/* (c) Texas Instruments 2009-2014, All rights reserved. */

#ifndef __REG_SCI_H__
#define __REG_SCI_H__

#include "sys_common.h"
#include "reg_gio.h"



/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Sci Register Frame Definition */
/** @struct sciBase
*   @brief SCI Base Register Definition
*
*   This structure is used to access the SCI module registers.
*/
/** @typedef sciBASE_t
*   @brief SCI Register Frame Type Definition
*
*   This type is used to access the SCI Registers.
*/
typedef volatile struct sciBase
{
    uint32_t GCR0;          /**< 0x0000 Global Control Register 0 */
    uint32_t GCR1;          /**< 0x0004 Global Control Register 1 */
    uint32_t rsdv1;         /**< 0x0008 Global Control Register 2 */
    uint32_t SETINT;       /**< 0x000C Set Interrupt Enable Register */
    uint32_t CLEARINT;      /**< 0x0010 Clear Interrupt Enable Register */
    uint32_t SETINTLVL;    /**< 0x0014 Set Interrupt Level Register */
    uint32_t CLEARINTLVL;   /**< 0x0018 Set Interrupt Level Register */
    uint32_t FLR;           /**< 0x001C Interrupt Flag Register */
    uint32_t INTVECT0;      /**< 0x0020 Interrupt Vector Offset 0 */
    uint32_t INTVECT1;      /**< 0x0024 Interrupt Vector Offset 1 */
    uint32_t FORMAT;        /**< 0x0028 Format Control Register */
    uint32_t BRS;           /**< 0x002C Baud Rate Selection Register */
    uint32_t ED;            /**< 0x0030 Emulation Register */
    uint32_t RD;            /**< 0x0034 Receive Data Buffer */
    uint32_t TD;            /**< 0x0038 Transmit Data Buffer */
    uint32_t PIO0;          /**< 0x003C Pin Function Register */
    uint32_t PIO1;          /**< 0x0040 Pin Direction Register */
    uint32_t PIO2;          /**< 0x0044 Pin Data In Register */
    uint32_t PIO3;          /**< 0x0048 Pin Data Out Register */
    uint32_t PIO4;          /**< 0x004C Pin Data Set Register */
    uint32_t PIO5;          /**< 0x0050 Pin Data Clr Register */
    uint32_t PIO6;          /**< 0x0054: Pin Open Drain Output Enable Register */
    uint32_t PIO7;          /**< 0x0058: Pin Pullup/Pulldown Disable Register */
    uint32_t PIO8;          /**< 0x005C: Pin Pullup/Pulldown Selection Register */
    uint32_t rsdv2[12U];    /**< 0x0060: Reserved                               */
    uint32_t IODFTCTRL;     /**< 0x0090: I/O Error Enable Register */
} sciBASE_t;


/** @def sciREG
*   @brief  Register Frame Pointer
*
*   This pointer is used by the SCI driver to access the sci module registers.
*/
#define sciREG ((sciBASE_t *)0xFFF7E400U)


/** @def sciPORT
*   @brief SCI GIO Port Register Pointer
*
*   Pointer used by the GIO driver to access I/O PORT of SCI
*   (use the GIO drivers to access the port pins).
*/
#define sciPORT ((gioPORT_t *)0xFFF7E440U)
/** @def sciREG
*   @brief  Register Frame Pointer
*
*   This pointer is used by the SCI driver to access the sci module registers.
*/
#define sciREG2 ((sciBASE_t *)0xFFF7E500U)


/** @def sciPORT
*   @brief SCI GIO Port Register Pointer
*
*   Pointer used by the GIO driver to access I/O PORT of SCI
*   (use the GIO drivers to access the port pins).
*/
#define sciPORT2 ((gioPORT_t *)0xFFF7E540U)


/** @def scilinREG
*   @brief SCILIN (LIN - Compatibility Mode)  Register Frame Pointer
*
*   This pointer is used by the SCI driver to access the sci module registers.
*/
#define scilinREG ((sciBASE_t *)0xFFF7E400U)


/** @def scilinPORT
*   @brief SCILIN (LIN - Compatibility Mode)  Register Frame Pointer
*
*   Pointer used by the GIO driver to access I/O PORT of LIN
*   (use the GIO drivers to access the port pins).
*/
#define scilinPORT ((gioPORT_t *)0xFFF7E440U)

/* USER CODE BEGIN (1) */
/* USER CODE END */


#endif
