/** @file reg_tcram.h
*   @brief TCRAM Register Layer Header File
*   @date 24.Feb.2014
*   @version 03.08.01
*   
*   This file contains:
*   - Definitions
*   - Types
*   .
*   which are relevant for the System driver.
*/

/* (c) Texas Instruments 2009-2014, All rights reserved. */

#ifndef __REG_TCRAM_H__
#define __REG_TCRAM_H__

#include "sys_common.h"

/* Tcram Register Frame Definition */
/** @struct tcramBase
*   @brief TCRAM Wrapper Register Frame Definition
*
*   This type is used to access the TCRAM Wrapper Registers.
*/
/** @typedef tcramBASE_t
*   @brief TCRAM Wrapper Register Frame Type Definition
*
*   This type is used to access the TCRAM Wrapper Registers.
*/

typedef volatile struct tcramBase
{
    uint32_t RAMCTRL;		    /* 0x0000 */
    uint32_t RAMTHRESHOLD;      /* 0x0004 */
    uint32_t RAMOCCUR;			/* 0x0008 */
    uint32_t RAMINTCTRL;		/* 0x000C */
    uint32_t RAMERRSTATUS;		/* 0x0010 */
    uint32_t RAMSERRADDR;		/* 0x0014 */
    uint32_t   rsvd1;			/* 0x0018 */
    uint32_t RAMUERRADDR;		/* 0x001C */
    uint32_t   rsvd2[4U];		/* 0x0020 */
    uint32_t RAMTEST;			/* 0x0030 */
    uint32_t   rsvd3;			/* 0x0034 */
    uint32_t RAMADDRDECVECT;	/* 0x0038 */
    uint32_t RAMPERADDR;        /* 0x003C */
} tcramBASE_t;

#define tcram1REG ((tcramBASE_t *)(0xFFFFF800U))
#define tcram2REG ((tcramBASE_t *)(0xFFFFF900U))

#endif
