;-------------------------------------------------------------------------------
; sys_intvecs.asm
;
; (c) Texas Instruments 2009-2013, All rights reserved.
;
    .cdecls C, NOLIST, WARN
    %{
        #include "bl_config.h"
    %}

    .sect ".intvecs"
    .arm

;-------------------------------------------------------------------------------
; import reference for interrupt routines

    .ref _c_int00
    .ref _dabort
    
    .def resetEntry

;        mov r0, #APP_START_ADDRESS
;        add r0, r0, #-4

;-------------------------------------------------------------------------------
resetEntry
        b   _c_int00                   ;0x00
        b   #0x1FFF8               ;0x04
        b   #0x1FFF8               ;0x08, Software interrupt
        b   #0x1FFF8               ;0x0C, Abort (prefetch)
        b   #0x1FFF8               ;0x10, Abort (data)

; interrupt vectors

;resetEntry
;        b   _c_int00
;undefEntry
;        b   undefEntry
;svcEntry
;        b   svcEntry
;prefetchEntry
;        b   prefetchEntry
;data_abort
;        b   data_abort
reservedEntry
        b   reservedEntry
        ldr pc,[pc,#-0x1b0]
        ldr pc,[pc,#-0x1b0]

    
;-------------------------------------------------------------------------------
