/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"
#include "F021.h"
#include"FapiFunctions.h"
#include "Registers.h"
#include "reg_flash.h"
#include "Registers_FMC_BE.h"
#include "Types.h"
#include <stdio.h>

/* USER CODE BEGIN (1) */
flashWBASE_t gh;    /*declared the flash register*/
extern unsigned int apiLoadStart;
extern unsigned int apiLoadSize;
extern unsigned int apiRunStart;


extern unsigned int constLoadStart;
extern unsigned int constLoadSize;
extern unsigned int constRunStart;
#define SYSTEM_FREQUENCY 80
char Data={'a'};

/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    int status=8,status1=9,status2=1,status3=2,status4=3,status5=6;
    /* Copy the flash APIs to SRAM*/
       //_copyAPI2RAM_(&apiLoadStart, &apiRunStart, &apiLoadSize);
       memcpy(&apiRunStart, &apiLoadStart, (uint32)&apiLoadSize);

       /* Copy the .const section */
       //_copyAPI2RAM_(&constLoadStart, &constRunStart, &constLoadSize);
       memcpy(&constRunStart, &constLoadStart, (uint32)&constLoadSize);
 /*setting Hclk frequency for initialization */
     status= Fapi_initializeFlashBanks(SYSTEM_FREQUENCY);    /*we have set PLL clk i.e 80MHz*/
     if(status!=Fapi_Status_Success)
     {
         printf("Failed to Initialize FlashBank=%d\n",status);
     }
     while(FAPI_CHECK_FSM_READY_BUSY!=Fapi_Status_FsmReady);
     status1=Fapi_setActiveFlashBank(Fapi_FlashBank0);     /*setting Bank 0 */
     if(status1!=Fapi_Status_Success)
         {
             printf("Failed to Set Active FlashBank=%d\n",status);
         }
         while(FAPI_CHECK_FSM_READY_BUSY!=Fapi_Status_FsmReady);
     status2=Fapi_enableMainBankSectors(14);     /*we have 14 sectors in Bank 0 so we gave "14" value */
     if(status2!=Fapi_Status_Success)
              {
                  printf("Failed to Sectors of  FlashBank=%d\n",status);
              }
              while(FAPI_CHECK_FSM_READY_BUSY!=Fapi_Status_FsmReady);
     status3=Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,0x00016000);
     if(status3!=Fapi_Status_Success)
                   {
                       printf("Failed to Sectors of  FlashBank=%d\n",status);
                   }
                   while(FAPI_CHECK_FSM_READY_BUSY!=Fapi_Status_FsmReady);

     status4=Fapi_issueProgrammingCommand(0x00016000,Data,sizeof(Data),0, 0,Fapi_DataOnly);
     if(status4!=Fapi_Status_Success)
                   {
                       printf("Failed to write hte data=%d\n",status);
                   }
                   while(FAPI_CHECK_FSM_READY_BUSY!=Fapi_Status_FsmReady);


/* USER CODE END */
while(1);
}


/* USER CODE BEGIN (4) */
/* USER CODE END */
