/*
 * rio_gio.c
 * Created on: 29-Apr-2024
 * Author: Lab To Market
 * Implementation of gpio functions for Remote I/O
 */

#include "HL_sys_common.h"
#include "HL_gio.h"
#include "HL_sci.h"
#include "HL_rti.h"
#include "HL_system.h"

#include "HL_het.h"
#include "HL_esm.h"
#include "HL_mibspi.h"
#include "HL_sys_core.h"

#define sciREGx sciREG1
extern udp_sendToServer(char);
extern udp_recvFromServer();

void wait(uint32_t time);
void sciDisplayTextgio(sciBASE_t *sci, uint8_t *text,uint32_t length);
uint8_t gioTitle[] = {"\r\n************** Into GPIO ****************"};
uint8_t gioButtonStatus[] = {"\r\nButton Status : "};
uint8_t gioIf[] = {"\r\n************** Into If ****************"};
uint8_t gioElse[] = {"\r\n************** Into Else ****************"};
uint8_t gioledOn1[] = {"\r\n************** Get Bit Returned 1 ****************"};
uint8_t gioledOn0[] = {"\r\n************** Get Bit returned 0 ****************"};
uint8_t match[] = {"\r\n************** MATCH ****************"};
uint8_t mismatch[] = {"\r\n************** MISMATCH ****************"};

uint32_t led1_status;
uint32_t led2_status;
char result_to_send;


void gio_read_write()
{
    rtiInit();
    gioInit();
    sciDisplayTextgio(sciREGx, gioTitle, sizeof(gioTitle));
    //sciDisplayTextgio(sciREGx, gioButtonStatus, sizeof(gioButtonStatus));

    while(1){

        //******************* USER BTN 1**********************
           if(gioGetBit(gioPORTB, 4) == 0){ // Button is pressed
               gioSetBit(gioPORTB, 6, 1);
               led1_status = gioGetBit(gioPORTB, 6);

           }
           else{ // Button is released
               gioSetBit(gioPORTB,6,0);
               led1_status = gioGetBit(gioPORTB, 6);
           }

           //****************** USER BTN 2********************
           if(gioGetBit(gioPORTB, 5)==0){ // Button is pressed
               gioSetBit(gioPORTB, 7, 1);
               led2_status = gioGetBit(gioPORTB, 7);
           }
           else{ // Button is released
               gioSetBit(gioPORTB, 7, 0);
               led2_status = gioGetBit(gioPORTB, 7);
           }

           if(led1_status == 1)
                result_to_send = '1';
           else
                result_to_send = '0';

           udp_sendToServer(result_to_send);
           //wait(1000);
           udp_recvFromServer();

           /*rtiEnableNotification(rtiREG1, rtiNOTIFICATION_COMPARE1);
           _enable_IRQ_interrupt_();
           rtiStartCounter(rtiREG1, rtiCOUNTER_BLOCK0);*/
       }
}

void rtiNotification(rtiBASE_t *rtiREG, uint32 notification){
    sciDisplayTextgio(sciREGx, gioTitle, sizeof(gioTitle));
    if(led1_status == 1)
        result_to_send = '1';
    else
        result_to_send = '0';
    udp_sendToServer(result_to_send);
   // udp_recvFromServer();
}

void sciDisplayTextgio(sciBASE_t *sci, uint8_t *text,uint32_t length)
{
    while(length--)
    {
        while ((sci->FLR & 0x4) == 4);
        sciSendByte(sci,*text++);
    };
}

void wait(uint32 time)
{
        time--;
}
