/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"
#include "system.h"

/* USER CODE BEGIN (1) */
#include "rti.h"
#include "esm.h"
#include "gio.h"
/* USER CODE END */

/* USER CODE BEGIN (2) */
int ctr = 0;
/* USER CODE END */

void main(void)
{
/* USER CODE BEGIN (3) */
    /* Enable interrupt */
    _enable_IRQ();
    /* Initialize GIO */
    gioInit();
    /* Initialize RTI */
    rtiInit();
    /* Enable RTI compare 0 notification */
    rtiEnableNotification(rtiNOTIFICATION_COMPARE0);
    /* Start counter */
    rtiStartCounter(rtiCOUNTER_BLOCK0);
    /* Initialize and start DWD */
    dwwdInit(Generate_Reset, 4095, Size_100_Percent);
    dwdCounterEnable();
    /* DWD is serviced in the RTI interrupt*/
    /* Delay */
    while(ctr < 50);
    /* Stop Servicing DWD */
    rtiDisableNotification(rtiNOTIFICATION_COMPARE0);

    while(1);

/* USER CODE END */
}

/* USER CODE BEGIN (4) */
void rtiNotification(uint32 notification)
{
    ctr++;
    gioToggleBit(gioPORTB,1);
    gioToggleBit(gioPORTB,2);
    dwdReset();
}
/* USER CODE END */
