/*
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== empty.c ========
 */
/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <ti/sysbios/knl/Clock.h>

/* TI-RTOS Header files */
#include <ti/drivers/EMAC.h>
#include <ti/drivers/GPIO.h>
// #include <ti/drivers/I2C.h>
// #include <ti/drivers/SDSPI.h>
// #include <ti/drivers/SPI.h>
// #include <ti/drivers/UART.h>
// #include <ti/drivers/USBMSCHFatFs.h>
// #include <ti/drivers/Watchdog.h>
// #include <ti/drivers/WiFi.h>
// #include <sys/socket.h>



#include <ti/ndk/inc/netmain.h>//http web server

#pragma DATA_SECTION(GREETINGS, ".htmldata");

#include <fs/fsHeader/greetings.h>
#include <fs/fsHeader/chip.h>

/* Board Header file */
#include "Board.h"

#define TASKSTACKSIZE   512

Task_Struct task0Struct;
Char task0Stack[TASKSTACKSIZE];

// Declare our CGI function entry point
//static int cgiSample(SOCKET htmlSock, int ContentLength);
//efs_loadfunction();

Int getTime(SOCKET s, int length);

Void AddWebFiles(Void)
{
    efs_createfile("index.html", GREETINGS_SIZE, (UINT8 *)GREETINGS);
    efs_createfile("chip0.jpg", CHIP_SIZE, (UINT8 *)CHIP);
    efs_createfile("chip1.jpg", CHIP_SIZE, (UINT8 *)CHIP);
    efs_createfile("chip2.jpg", CHIP_SIZE, (UINT8 *)CHIP);
    efs_createfile("chip3.jpg", CHIP_SIZE, (UINT8 *)CHIP);
    efs_createfile("chip4.jpg", CHIP_SIZE, (UINT8 *)CHIP);
    efs_createfile("chip5.jpg", CHIP_SIZE, (UINT8 *)CHIP);
    efs_createfile("chip6.jpg", CHIP_SIZE, (UINT8 *)CHIP);
    efs_createfile("chip7.jpg", CHIP_SIZE, (UINT8 *)CHIP);
    System_printf("AddWebFiles Done\n");
    System_flush();
}

Void RemoveWebFiles(Void)
{
    efs_destroyfile("index.html");
    efs_destroyfile("chip0.jpg");
    efs_destroyfile("chip1.jpg");
    efs_destroyfile("chip2.jpg");
    efs_destroyfile("chip3.jpg");
    efs_destroyfile("chip4.jpg");
    efs_destroyfile("chip5.jpg");
    efs_destroyfile("chip6.jpg");
    efs_destroyfile("chip7.jpg");
}

Int getTime(SOCKET s, int length)
{
    Char buf[200];
    static UInt scalar = 0;

    if (scalar == 0) {
        scalar = 1000000u / Clock_tickPeriod;
    }
    httpSendStatusLine(s, HTTP_OK, CONTENT_TYPE_HTML);
    httpSendClientStr(s, CRLF);
    httpSendClientStr(s,
        "<html><head><title>SYS/BIOS Clock "\
	"Time</title></head><body><h1>Time</h1>\n");
    System_sprintf(buf, "<p>Up for %d seconds</p>\n",
        ((unsigned long)Clock_getTicks() / scalar));
    httpSendClientStr(s, buf);
    httpSendClientStr(s, "</table></body></html>");
    return (1);
}


/*
 *  ======== heartBeatFxn ========
 *  Toggle the Board_LED0. The Task_sleep is determined by arg0 which
 *  is configured for the heartBeat Task instance.
 */
/*
Void heartBeatFxn(UArg arg0, UArg arg1)
{
    while (1) {
        Task_sleep((unsigned int)arg0);
        GPIO_toggle(Board_LED0);
    }
}
*/

/*
 *  ======== main ========
 */
int main(void)
{
    //Task_Params taskParams;
    /* Call board init functions */
    Board_initGeneral();
    Board_initEMAC();
    Board_initGPIO();
    // Board_initI2C();
    // Board_initSDSPI();
    // Board_initSPI();
    // Board_initUART();
    // Board_initUSB(Board_USBDEVICE);
    // Board_initUSBMSCHFatFs();
    // Board_initWatchdog();
    // Board_initWiFi();

    /* Construct heartBeat Task  thread */
/*
    Task_Params_init(&taskParams);
    taskParams.arg0 = 1000;
    taskParams.stackSize = TASKSTACKSIZE;
    taskParams.stack = &task0Stack;
    Task_construct(&task0Struct, (Task_FuncPtr)heartBeatFxn, &taskParams, NULL);
*/
     /* Turn on user LED */
    GPIO_write(Board_LED0, Board_LED_ON);

    System_printf("Starting the example\nSystem provider is set to SysMin. "
                  "Halt the target to view any SysMin contents in ROV.\n");
    /* SysMin will only print to the console when you call flush or exit */
    System_flush();

    /* Start BIOS */
    BIOS_start();

    return (0);
}


