/*
 * RFA_SCAN_time.c
 *
 *  Created on: 18-Apr-2018
 *      Author: HP
 */

#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "inc/hw_can.h"
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "driverlib/debug.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"
#include "driverlib/adc.h"
#include "driverlib/can.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"

uint32_t freq=1;
uint32_t PeakADC1;
uint32_t PeakADC1;
uint32_t ui32ACCValues0=0;
uint32_t ui32ACCValues1=0;
uint32_t ui32ACCavg0;
uint32_t ui32ACCavg1;
float RevPow=0.0;
int i=0;
uint32_t ui32SysClock=0;
volatile bool g_bErrFlag = 0;
volatile bool g_bTXFlag = 0;

void SimpleDelay(void)
{
    SysCtlDelay(40000);
}

void CANIntHandler(void)
{
    uint32_t ui32Status;
    ui32Status = CANIntStatus(CAN1_BASE, CAN_INT_STS_CAUSE);
   if(ui32Status == CAN_INT_INTID_STATUS)
    {
        ui32Status = CANStatusGet(CAN1_BASE, CAN_STS_CONTROL);
        g_bErrFlag = 1;
    }

    else if(ui32Status == 1)
    {
        CANIntClear(CAN1_BASE, 1);
        CANMessageClear(CAN1_BASE, 1);
        g_bErrFlag = 0;
        g_bTXFlag = 1;
    }
    else
    {
    }
}



int main(void)

{
    tCANMsgObject sCANMessage;
    uint16_t ui32MsgData[2]={0,0};
    uint8_t *pui8MsgData;
    pui8MsgData = (uint8_t *)ui32MsgData;

    ui32SysClock = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN | SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), 120000000);  //external Freq source:SYSCTL_XTAL_25MHZ  oscillator source:SYSCTL_OSC_MAIN   sys clk source PLL or ocillator:SYSCTL_USE_PLL  //PLL VCO frequency is choosen between one of the value 480-320MHz:SYSCTL_CFG_VCO_480 // last will be sys clock freq: 120MHz

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);
    SimpleDelay();

    GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_4);
    GPIOPinConfigure(GPIO_PB0_CAN1RX);
    GPIOPinConfigure(GPIO_PB1_CAN1TX);
    GPIOPinTypeCAN(GPIO_PORTB_BASE, GPIO_PIN_0 | GPIO_PIN_1);


    SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC1);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_CAN1);
    GPIOPinTypeADC(GPIO_PORTD_BASE, GPIO_PIN_0 | GPIO_PIN_7); //PD0-CH15-REV.Pow PD7-CH4-FOW.Pow

    ADCClockConfigSet(ADC0_BASE, ADC_CLOCK_SRC_PLL | ADC_CLOCK_RATE_FULL,15);
    ADCClockConfigSet(ADC1_BASE, ADC_CLOCK_SRC_PLL | ADC_CLOCK_RATE_FULL,15);

    ADCSequenceConfigure(ADC0_BASE, 3, ADC_TRIGGER_ALWAYS, 0);
    ADCSequenceConfigure(ADC1_BASE, 3, ADC_TRIGGER_ALWAYS, 0);

    ADCSequenceStepConfigure(ADC0_BASE, 3, 0, ADC_CTL_CH4|ADC_CTL_IE|ADC_CTL_END); //FOW.Pow
    ADCSequenceStepConfigure(ADC1_BASE, 3, 0, ADC_CTL_CH15|ADC_CTL_IE|ADC_CTL_END); //REV.Pow

    CANInit(CAN1_BASE);SimpleDelay();
    CANBitRateSet(CAN1_BASE, ui32SysClock, 1000000);SimpleDelay();


    ADCSequenceEnable(ADC0_BASE, 3);
    ADCSequenceEnable(ADC1_BASE, 3);

    ADCIntClear(ADC0_BASE, 3);
    ADCIntClear(ADC1_BASE, 3);

    CANIntRegister(CAN1_BASE, CANIntHandler);SimpleDelay();
    CANIntEnable(CAN1_BASE, CAN_INT_MASTER | CAN_INT_ERROR | CAN_INT_STATUS);SimpleDelay();
    IntEnable(INT_CAN1);SimpleDelay();
    CANEnable(CAN1_BASE);SimpleDelay();

    sCANMessage.ui32MsgID = 2;
    sCANMessage.ui32MsgIDMask = 0;
    sCANMessage.ui32Flags = MSG_OBJ_TX_INT_ENABLE;
    sCANMessage.ui32MsgLen = sizeof(pui8MsgData);
    sCANMessage.pui8MsgData = pui8MsgData;

    i=0;
    ui32ACCavg0=0;
    ui32ACCavg1=0;
    g_bTXFlag=1;

    while(1)
        {
            while(!ADCIntStatus(ADC0_BASE, 3, false) & !ADCIntStatus(ADC1_BASE,3, false))
            {
            }
            ADCSequenceDataGet(ADC0_BASE, 3,&ui32ACCValues0);
            ADCSequenceDataGet(ADC1_BASE, 3,&ui32ACCValues1);
            while(ui32ACCValues1 < 0x936) //1.90V
            {
                ui32ACCavg0 = ui32ACCavg0 + ui32ACCValues0;
                ui32ACCavg1 = ui32ACCavg1 + ui32ACCValues1;
                ADCIntClear(ADC0_BASE, 3);
                ADCIntClear(ADC1_BASE, 3);
                while(!ADCIntStatus(ADC0_BASE, 3, false) & !ADCIntStatus(ADC1_BASE,3, false))
                {
                }
                ADCSequenceDataGet(ADC0_BASE, 3,&ui32ACCValues0);
                ADCSequenceDataGet(ADC1_BASE, 3,&ui32ACCValues1);
                i++;
                if(ui32ACCValues1 > 0x8BA || i>=100)   //1.90V
                {
                    if(g_bTXFlag)
                    {
                        g_bTXFlag=0;
                        ui32MsgData[0]=ui32ACCavg0/i;
                        ui32MsgData[1]=ui32ACCavg1/i;
                        CANMessageSet(CAN1_BASE, 1, &sCANMessage, MSG_OBJ_TYPE_TX);
                    }
                    ui32ACCavg0=0;
                    ui32ACCavg1=0;
                    i=0;
                    break;
                }
            }
            ADCIntClear(ADC0_BASE, 3);
            ADCIntClear(ADC1_BASE, 3);
        }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Two Analog channel used at a time. START
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/debug.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"
#include "driverlib/adc.h"



uint32_t freq=1;
uint32_t PeakADC1;
uint32_t PeakADC1;
uint32_t ui32ACCValues0=0,ui32TEMPcnt=0;
uint32_t ui32ACCValues1=0;
uint32_t ui32ACCavg0;
uint32_t ui32ACCavg1;
float RevPow=0.0;
int i=0;

int main(void)

{

    freq = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN | SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), 120000000);  //external Freq source:SYSCTL_XTAL_25MHZ  oscillator source:SYSCTL_OSC_MAIN   sys clk source PLL or ocillator:SYSCTL_USE_PLL  //PLL VCO frequency is choosen between one of the value 480-320MHz:SYSCTL_CFG_VCO_480 // last will be sys clock freq: 120MHz

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);

    SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC1);

    GPIOPinTypeADC(GPIO_PORTD_BASE, GPIO_PIN_0 | GPIO_PIN_7); //PD0-CH15-REV.Pow PD7-CH4-FOW.Pow
    GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_4);

    ADCClockConfigSet(ADC0_BASE, ADC_CLOCK_SRC_PLL | ADC_CLOCK_RATE_FULL,15);
    ADCClockConfigSet(ADC1_BASE, ADC_CLOCK_SRC_PLL | ADC_CLOCK_RATE_FULL,15);

    ADCSequenceConfigure(ADC0_BASE, 3, ADC_TRIGGER_ALWAYS, 0);
    ADCSequenceConfigure(ADC1_BASE, 3, ADC_TRIGGER_ALWAYS, 0);

    ADCSequenceStepConfigure(ADC0_BASE, 3, 0, ADC_CTL_CH4|ADC_CTL_IE|ADC_CTL_END); //FOW.Pow
    ADCSequenceStepConfigure(ADC1_BASE, 3, 0, ADC_CTL_CH15|ADC_CTL_IE|ADC_CTL_END); //REV.Pow

    ADCSequenceEnable(ADC0_BASE, 3);
    ADCSequenceEnable(ADC1_BASE, 3);

    ADCIntClear(ADC0_BASE, 3);
    ADCIntClear(ADC1_BASE, 3);
    i=0;
    ui32ACCavg0=0;
    ui32ACCavg1=0;

    while(1)
        {
            while(!ADCIntStatus(ADC0_BASE, 3, false) & !ADCIntStatus(ADC1_BASE,3, false))
            {
            }
            ADCSequenceDataGet(ADC0_BASE, 3,&ui32ACCValues0);
            ADCSequenceDataGet(ADC1_BASE, 3,&ui32ACCValues1);
            while(ui32ACCValues1 < 0x936) //1.90V
            {
                ui32ACCavg0 = ui32ACCavg0 + ui32ACCValues0;
                ui32ACCavg1 = ui32ACCavg1 + ui32ACCValues1;
                ADCIntClear(ADC0_BASE, 3);
                ADCIntClear(ADC1_BASE, 3);
                while(!ADCIntStatus(ADC0_BASE, 3, false) & !ADCIntStatus(ADC1_BASE,3, false))
                {
                }
                ADCSequenceDataGet(ADC0_BASE, 3,&ui32ACCValues0);
                ADCSequenceDataGet(ADC1_BASE, 3,&ui32ACCValues1);
                i++;
                if(ui32ACCValues1 > 0x8BA || i>=100)   //1.90V
                {
                    PeakADC1=ui32ACCavg0/i;
                    PeakADC1=ui32ACCavg1/i;
                    RevPow=(PeakADC1*3.3)/4095;
                    ui32ACCavg0=0;
                    ui32ACCavg1=0;
                    i=0;
                    break;
                }
            }
            ADCIntClear(ADC0_BASE, 3);
            ADCIntClear(ADC1_BASE, 3);
        }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Two Analog channel used at a time. END
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Single Analog channel used. START
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/debug.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"
#include "driverlib/adc.h"



uint32_t freq=1;
uint32_t PeakADC1;
uint32_t PeakADC1;
uint32_t ui32ACCValues[4]={0,0,0,0},ui32TEMPcnt=0;
uint32_t ui32ACCavg0;
uint32_t ui32ACCavg1;
float RevPow=0.0;
int i=0;

int main(void)

{

    freq = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN | SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), 120000000);  //external Freq source:SYSCTL_XTAL_25MHZ  oscillator source:SYSCTL_OSC_MAIN   sys clk source PLL or ocillator:SYSCTL_USE_PLL  //PLL VCO frequency is choosen between one of the value 480-320MHz:SYSCTL_CFG_VCO_480 // last will be sys clock freq: 120MHz

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);

    SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC1);

    GPIOPinTypeADC(GPIO_PORTD_BASE, GPIO_PIN_0 | GPIO_PIN_7); //PD0-CH15-REV.Pow PD7-CH4-FOW.Pow
    GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_4);

    ADCClockConfigSet(ADC1_BASE, ADC_CLOCK_SRC_PLL | ADC_CLOCK_RATE_FULL,15);

    ADCSequenceConfigure(ADC1_BASE, 1, ADC_TRIGGER_ALWAYS, 0);

    //ADCSequenceStepConfigure(ADC1_BASE, 1, 0, ADC_CTL_CH4);
    //ADCSequenceStepConfigure(ADC1_BASE, 1, 1, ADC_CTL_CH15);
    ADCSequenceStepConfigure(ADC1_BASE, 1, 2, ADC_CTL_CH4);
    ADCSequenceStepConfigure(ADC1_BASE, 1, 3, ADC_CTL_CH15|ADC_CTL_IE|ADC_CTL_END); //FOW.Pow

    ADCSequenceEnable(ADC1_BASE, 1);

    ADCIntClear(ADC1_BASE, 1);
    i=0;
    ui32ACCavg0=0;
    ui32ACCavg1=0;
    GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_1, GPIO_PIN_1);
    GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_2, GPIO_PIN_2);
    while(1)
        {
            while(!ADCIntStatus(ADC1_BASE, 1, false))
            {
            }
            ADCSequenceDataGet(ADC1_BASE, 1, ui32ACCValues);
            while(ui32ACCValues[3] < 0x83D) //1.70V
            {

                ui32ACCavg0 = ui32ACCavg0 + ui32ACCValues[2];
                ui32ACCavg1 = ui32ACCavg1 + ui32ACCValues[3];
                GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_1, 0);
                ADCIntClear(ADC1_BASE, 1);
                GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_1, GPIO_PIN_1);
                while(!ADCIntStatus(ADC1_BASE, 1, false))
                {
                }
                ADCSequenceDataGet(ADC1_BASE, 1, ui32ACCValues);

                i++;
                if(ui32ACCValues[3] > 0x8F7 || i>=100)
                {
                    GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_1, 0);
                    PeakADC1=ui32ACCavg0/i;
                    PeakADC1=ui32ACCavg1/i;
                    RevPow=(PeakADC1*3.3)/4095;
                    ui32ACCavg0=0;
                    ui32ACCavg1=0;
                    ADCIntClear(ADC1_BASE, 1);
                    i=0;
                    break;
                }
            }
            GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_2, 0);
            ADCIntClear(ADC1_BASE, 1);
            GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_2, GPIO_PIN_2);
        }
}
*/
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Single Analog channel used. END
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
