
#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "inc/hw_can.h"
#include "inc/hw_ints.h"
#include "driverlib/debug.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"
#include "driverlib/adc.h"
#include "driverlib/can.h"
#include "driverlib/interrupt.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"


uint32_t ui32ACCValues1=0;
uint32_t ui32ACCavg1;
uint8_t Count=0;
uint32_t ui32SysClock=0;
volatile bool g_bErrFlag = 0;
volatile bool g_bTXFlag = 0;

void SimpleDelay(void)
{
    SysCtlDelay(40000);
}

void CANIntHandler(void)
{
    uint32_t ui32Status;
    ui32Status = CANIntStatus(CAN0_BASE, CAN_INT_STS_CAUSE);
   if(ui32Status == CAN_INT_INTID_STATUS)
    {
        ui32Status = CANStatusGet(CAN0_BASE, CAN_STS_CONTROL);
        g_bErrFlag = 1;
    }

    else if(ui32Status == 1)
    {
        CANIntClear(CAN0_BASE, 1);
        CANMessageClear(CAN0_BASE, 1);
        g_bErrFlag = 0;
        g_bTXFlag = 1;
    }
    else
    {
    }
}


int main(void)

{

    uint32_t ui32MsgData=0;
    uint8_t *pui8MsgData;
    pui8MsgData = (uint8_t *)&ui32MsgData;
    tCANMsgObject sCANMessage;
    sCANMessage.ui32MsgID = 1;
    sCANMessage.ui32MsgIDMask = 0;
    sCANMessage.ui32Flags = MSG_OBJ_TX_INT_ENABLE;
    sCANMessage.ui32MsgLen = sizeof(pui8MsgData);
    sCANMessage.pui8MsgData = pui8MsgData;


    ui32SysClock = SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN | SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), 120000000);  //external Freq source:SYSCTL_XTAL_25MHZ  oscillator source:SYSCTL_OSC_MAIN   sys clk source PLL or ocillator:SYSCTL_USE_PLL  //PLL VCO frequency is choosen between one of the value 480-320MHz:SYSCTL_CFG_VCO_480 // last will be sys clock freq: 120MHz

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    SimpleDelay();

    GPIOPinConfigure(GPIO_PA0_CAN0RX);
    GPIOPinConfigure(GPIO_PA1_CAN0TX);
    GPIOPinTypeCAN(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

    SysCtlPeripheralEnable(SYSCTL_PERIPH_ADC1);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_CAN0);
    GPIOPinTypeADC(GPIO_PORTD_BASE, GPIO_PIN_5); //PD5-CH6-Temperature
    ADCClockConfigSet(ADC1_BASE, ADC_CLOCK_SRC_PLL | ADC_CLOCK_RATE_FULL,15);
    ADCSequenceConfigure(ADC1_BASE, 3, ADC_TRIGGER_ALWAYS, 0);
    ADCSequenceStepConfigure(ADC1_BASE, 3, 0, ADC_CTL_CH6|ADC_CTL_IE|ADC_CTL_END); //REV.Pow

    CANInit(CAN0_BASE);SimpleDelay();
    CANBitRateSet(CAN0_BASE, 120000000, 1000000);SimpleDelay();

    ADCSequenceEnable(ADC1_BASE, 3);
    ADCIntClear(ADC1_BASE, 3);

    CANIntRegister(CAN0_BASE, CANIntHandler);SimpleDelay();
    CANIntEnable(CAN0_BASE, CAN_INT_MASTER | CAN_INT_ERROR | CAN_INT_STATUS);SimpleDelay();
    IntEnable(INT_CAN0);SimpleDelay();
    CANEnable(CAN0_BASE);SimpleDelay();



    Count=0;
    ui32ACCavg1=0;
    g_bTXFlag=1;

    while(1)
        {
            while(g_bTXFlag)
            {
                g_bTXFlag=0;
                Count=0;
                while(Count<10)
                {
                    while(!ADCIntStatus(ADC1_BASE, 3, false))
                    {
                    }
                    ADCSequenceDataGet(ADC1_BASE, 3,&ui32ACCValues1);
                    ADCIntClear(ADC1_BASE, 3);
                    ui32ACCavg1=ui32ACCavg1+ui32ACCValues1;
                    Count++;
                }
                ui32MsgData=ui32ACCavg1/10;
                CANMessageSet(CAN0_BASE, 1, &sCANMessage, MSG_OBJ_TYPE_TX);
                ui32ACCavg1=0;
                SimpleDelay();
            }

        }
}

